{- 	Work in progress...
	We try to provide abstractions over MVars, Synchrnous(hand-shaking), Fifo,
	Bounded, Rendezvous, and Files...
-}

module ChClass
(	  MVar		-- type
	, Sync		-- type
	, Fifo		-- type
--	, Rendz		-- type 			-- TODO
--	, File		-- type				-- TODO


	, newMVarCh	-- :: IO (MVar a)
	, newSyncCh	-- :: IO (Sync a)
	, newFifoCh	-- :: Int -> IO (Fifo a) 	-- 0=unbounded, +n=maximum FIFO size

--	, newRendzCh	-- :: IO (Rendz a)		-- TODO
--	, newFileCh	-- :: String -> IO (File a) 	-- TODO: unfortunately we don't have binary files...

	, Channel	-- class
	, isemptyCh	-- :: (s a) -> IO Bool		-- (non-blocking) is it empty?
	, isfullCh	-- :: (s a) -> IO Bool		-- (non-blocking) is it full?
	, putCh		-- :: (s a) -> a -> IO ()	-- put
	, tryPutCh	-- :: (s a) -> a -> IO Bool	-- (non-blocking) True if put was succesful
	, getCh		-- :: (s a) -> IO a 		-- get
	, tryGetCh	-- :: (s a) -> IO (Maybe a)	-- (non-blocking) Just result if can get
	, lookCh	-- :: (s a) -> IO (Maybe a)	-- (non-blocking) Just result to look without altering channel
	, writeCh	-- :: (s a) -> [a] -> IO ()	-- write in an un-interuptable stream
	, readCh        -- :: (s a) -> IO [a]		-- (non-blocking) read out an un-interuptable stream
	, snapCh	-- :: (s a) -> IO [a]		-- (non-blocking) look at the stream without altering the channel
	
)

where

import Distributed
import qualified Channel
import qualified Bounded

-------------------------------
class Channel s where
  isemptyCh	:: (s a) -> IO Bool		
  isfullCh	:: (s a) -> IO Bool	

  putCh		:: (s a) -> a -> IO ()	
  tryPutCh	:: (s a) -> a -> IO Bool
  getCh		:: (s a) -> IO a 
  tryGetCh	:: (s a) -> IO (Maybe a)
  lookCh	:: (s a) -> IO (Maybe a)

  writeCh	:: (s a) -> [a] -> IO ()
  readCh        :: (s a) -> IO [a]
  snapCh	:: (s a) -> IO [a]

  isemptyCh x	= do
		jv <- lookCh x
		case jv of
		  (Just _) -> return False
		  Nothing  -> return True
  isfullCh x    = error "Unimplemented: isfullCh"
  putCh x v	= error "Unimplemented: putCh"
  tryPutCh x v	= error "Unimplemented: tryPutCh"
  getCh x	= error "Unimplemented: getCh"
  tryGetCh	= error "Unimplemented: tryGetCh"
  lookCh x	= error "Unimplemented: lookCh"
  writeCh x	= error "Unimplemented: writeCh"
  readCh x	= error "Unimplemented: readCh"
  snapCh x 	= error "Unimplemented: snapCh"


-- MVar -----------------------
-- put succeeds immediately but fails if a value already exists in the channel.
-- take blocks until a value is in the channel.

newMVarCh = newEmptyMVar

instance Show (MVar a) where
  showsPrec _ c s = "(MVar ..)" ++ s

instance Channel MVar where
  putCh = putMVar
  
  tryPutCh = tryPutMVar

  getCh = takeMVar

  tryGetCh = takeMaybeMVar

  -- lookCh : Unimplementable - the MVar would appear momentarily empty

  isemptyCh =  isEmptyMVar

  isfullCh m = do
		t <- isEmptyMVar m
		return (not t) 

-- Sync -----------------------
-- put blocks until a take occurs.
-- take block until a put occurs.

data Sync a = Sync  (MVar a)  (MVar ()) 

newSyncCh = do
	r <- newEmptyMVar
        w <-newMVar ()
        return (Sync r w)
		
instance Show (Sync a) where
  showsPrec _ c s = "(Sync ..)" ++ s

instance Immobile (Sync a) where   
  owningPE (Sync r _) = owningPE r

instance Channel Sync where
  putCh (Sync r w) v = do
	let work = do
		takeMVar w
        	putMVar r v 
	revalIO work r

  tryPutCh (Sync r w) v = do
	let work = do
		m <- takeMaybeMVar w	
		case m of
		  (Just _) -> do
			putMVar r v
			return True
		  Nothing  -> return False
	revalIO work r

  getCh (Sync r w) = do
        let work = do
		v <- takeMVar r
        	putMVar w ()
        	return v
	revalIO work r

  tryGetCh (Sync r w) = do
	let work = do
		m <- takeMaybeMVar r
		case m of
		  (Just v) -> putMVar w ()
		  Nothing  -> return ()
		return m
	revalIO work r

  -- lookCh : Unimplementable - the Sync would appear momentarily empty

  isemptyCh (Sync r _) =  isEmptyMVar r

  isfullCh (Sync r _) = do
		t <- isEmptyMVar r
		return (not t) 

-- FIFO ---------------------- where 0=unbounded, +n = maximum size
-- put blocks if the queue is full.
-- take blocks if the queue is empty.

newFifoCh 0 = do
	c <- Channel.newChan
	return (FifoC c)
newFifoCh n = do
	b <- Bounded.newBound n
	return (FifoB b)

data Fifo a = FifoC (Channel.Chan a) | FifoB (Bounded.Bound a)

instance Immobile (Fifo a) where
  owningPE (FifoC c) = owningPE c
  owningPE (FifoB b) = owningPE b

instance Show (Fifo a) where
  showsPrec _ (FifoC _) s = "(Fifo ..)" ++ s
  showsPrec _ (FifoB _) s = "(Fifo(bounded) ..)" ++ s

instance Channel Fifo where
  putCh (FifoC c) = Channel.writeChan c
  putCh (FifoB b) = Bounded.writeBound b

  tryPutCh (FifoC c) v = do
		Channel.writeChan c v
		return True
  tryPutCh (FifoB b) _ = error "Unimplemented: tryPutCh(bounded)"

  getCh	(FifoC c) = Channel.readChan c
  getCh (FifoB b) = Bounded.readBound b

  writeCh (FifoC c) = Channel.addChan c
  writeCh (FifoB _) = error "Unimplemented: writeCh(bounded)"

  readCh (FifoC c) = Channel.flushChan c
  readCh (FifoB _) = error "Unimplemented: readCh(bounded)"

  snapCh (FifoC c) = Channel.snapChan c
  snapCh (FifoB b) = Bounded.snapBound b

  isemptyCh (FifoC c) = Channel.isEmptyChan c
  isemptyCh (FifoB b) = Bounded.isEmptyBound b

  isfullCh (FifoC c) = return False
  isfullCh (FifoB b) = Bounded.isFullBound b

-- RENDZ---------------------- 
-- put blocks until a get occurs and vice-versa.

{-

newRendzCh = ...

data Rendz = Rendz ...

instance Show (Rendz a) where
  showsPrec _ c s = "(Rendz ..)" ++ s

instance Immobile (Rendz a) where ...

instance Channel Rendz where ...

-}

