{- 	Don't use this module!!! 
  	It is simply proof of concept...
-}

module MVar 
(	MVar,		-- abstract

	newEmptyMVar,	-- :: IO (MVar a)

	takeMVar,	-- :: MVar a -> IO a
	putMVar,	-- :: MVar a -> a -> IO ()

	tryPutMVar,	-- :: MVar a -> a -> IO Bool
	tryTakeMVar,	-- :: MVar a -> IO (Maybe a)

	isEmptyMVar,	-- :: MVar a -> IO Bool	

	newMVar,	-- :: a -> IO (MVar a)
	readMVar,	-- :: MVar a -> IO a
        swapMVar	-- :: MVar a -> a -> IO a
) where

import MutSig
import Maybe

type MVar a = (Mutex (Maybe a), Signal) 

newEmptyMVar :: IO (MVar a)
newEmptyMVar = do
	m <-newMutex Nothing
	s <-newSignal
	return (m,s)	
	
takeMVar :: MVar a -> IO a
takeMVar (m,s) = lock m
	( \x -> do
		Just v <- wait s m isNothing x
	  	return (Nothing,v)
	)

putMVar :: MVar a -> a -> IO ()
putMVar (m,s) v = lock m
	( \vs -> do
		case vs of
		  Just x  -> error "MVar full"
		  Nothing -> signal s
		return ((Just v),())
	)

tryPutMVar :: MVar a -> a -> IO Bool
tryPutMVar (m,s) v = lock m
	( \vs -> do
		case vs of
		  Just x  -> return (vs,False)
		  Nothing -> do
			signal s
			return ((Just v),True)
	)

tryTakeMVar :: MVar a -> IO (Maybe a)
tryTakeMVar (m,_) = lock m ( \vs -> return (Nothing,vs))

isEmptyMVar :: MVar a -> IO Bool
isEmptyMVar (m,_) = lock m (\vs -> return (vs,isNothing vs))

newMVar:: a -> IO (MVar a)
newMVar v = do
	m <- newEmptyMVar
	putMVar m v
	return m

{- the following are usually constructed from take&put, but thats
   potentially dangerous given its not atomic. So we provide them
   directly.
-}

readMVar :: MVar a -> IO a
readMVar (m,s) = lock m
	( \x -> do
		Just v <- wait s m isNothing x
	  	return ((Just v),v)
	)

swapMVar :: MVar a -> a -> IO a
swapMVar (m,s) n = lock m
	( \x -> do
		Just v <- wait s m isNothing x
	  	return ((Just n),v)
	)
