module MutSig
(	Mutex,		-- :: abstract
	Signal,		-- :: abstract
	
	newSignal,	-- :: IO Signal
	newMutex,	-- :: a -> IO (Mutex a)

	lock,		-- :: Mutex a -> (a -> IO (a,b)) -> IO b
	wait,		-- :: Signal -> Mutex a -> (a-> Bool) -> a -> IO a
	signal		-- :: Signal -> IO ()

{-	LOCK:
	- non re-enterable lock.
	- an exception occuring once the lock is held will
	  cause the lock to release and revert to the original state.
	- BUG: a race condition exists for asynchrnous exceptions.
	- BUG: a lock should be re-enterable for the owning thread, problem is
		we can't yet correctly identify revalIO threads...

	WAIT:
	- wait while condition is True.
	- BUG: assumes the mutex is held upon entry!!!!!!
		
	SIGNAL:
	- only one signal is stored, multiple signals are lost.
	- signals are only checked within a wait (thus when the mutex is released).
-}

) where

import Distributed
import Exception

type Mutex a = MVar a

type Signal = MVar ()

newSignal :: IO Signal
newSignal = newEmptyMVar

newMutex :: a -> IO (Mutex a)
newMutex vs = newMVar vs

lock :: Mutex a -> (a -> IO (a,b)) -> IO b
lock m job = do
	let remote = do
		vs <- takeMVar m
		let work = do
			(vss,x) <- job vs
			putMVar m vss
			return x
		let undo e = do
			tryPutMVar m vs
			throw e
		catchAllIO work undo		
	revalIO remote m  -- simple but effective optimisation

wait :: Signal -> Mutex a -> (a-> Bool) -> a -> IO a
wait s m p vs = do
	if (p vs) 
	  then	do
		putMVar m vs
		takeMVar s
		vs <- takeMVar m
		wait s m p vs
	  else  return vs	

signal :: Signal -> IO ()
signal s = do
	tryPutMVar s ()
	return ()