module PrelDistributed
(	  PEId (..)
	, primRevalIO		-- :: a -> PEId -> IO ()
	, primGetCertainOwner	-- :: a -> IO PEId
) where
import PrelConc(MVar, newMVar)
import PrelGHC (unsafeCoerce#,CCallable)

{- this module contains the unpleasant stuff:

   1/ We typecast everything to make primGetCertainOwner polymorphic!
   2/ We assume that MVars are CCallable!

   MVars are **NOT** CCallable by default, so to compile this module you
   basically have to rip the guts out of the typechecker to disable the
   CCallable checks.
   I therefore reccommend just compiling this module from the *.hc and 
   *.hi files for the meantime.
-}


data PEId = PEId Int 
	 deriving (Ord, Eq)

type Obj = MVar ()
instance CCallable Obj -- type system will break!!!!

obj :: a -> Obj	
obj x = unsafeCoerce# x 

primRevalIO :: a -> PEId -> IO ()
primRevalIO res (PEId p) = do
	mv <- newMVar res 
	_ccall_ cRevalIO (obj mv) p

primGetCertainOwner :: a -> IO PEId
primGetCertainOwner x = do
	p <- _ccall_ cGetCertainOwner (obj x)
	return (PEId p)

