module Main(main) where

import Distributed
import System
import IO
import Time 
import PrelNum

-- we are only interested in us accuracy < 60 secs
runTime :: ClockTime -> ClockTime -> String
runTime t1 t2 = 
	let
	  TimeDiff _ _ d h m s p = diffClockTimes t1 t2
	  (tus,_) = divModInteger p 1000000 -- scale the pico-seconds
	  (ims,ius) = divModInteger tus 1000
	  (tms,us) = (integer2Int ims, integer2Int ius)
	  (ms,ts) = if(tms<0) then (tms+1000,s-1) else (tms,s) -- correct for overflows
	  (sec,tmin) = if(ts<0) then (ts+60,m-1) else (ts,m) -- correct for overflows
	  dec3 n = "."++(if(n<10) then "00" else if (n<100) then "0" else "")++show n -- formating
	in  -- formatting
	  if(sec/=0) then show sec++dec3 ms++" sec"
	  else if(ms/=0) then show ms++dec3 us++" msec"
	  else show us++" usec"

timeit :: IO a -> IO (a, String)
timeit job = do
	start <- getClockTime
	res <- job
	done <- getClockTime
	return (res,(runTime done start))
			
main =	do 
 	args <- getArgs
	prog <- getProgName
	let n = if (length args)>0 then read (args!!0) else 1

	putStrLn (prog++" x"++show n)
	pes <- allPEId
	
	let	
	  timePing job p = do -- show the time the job takes
		putStr ("Pinging "++(show p)++" ... ")
		(name,time) <- timeit (job p)
		putStrLn ("at "++name++" time="++time)

	  pingPong p = revalIO remote p -- perform the remote operation
	  
	  remote = getEnv "HOST" -- the remote work to do

	  timePingAll n = do
		putStrLn ("Ping "++show n)
		mapM (timePing pingPong) pes
		
	mapM timePingAll [1..n] --repeat n times	
	return ()

