/* -*- mode: hugs-c; -*- */

/* --------------------------------------------------------------------------
 * Instructions
 *
 * Notes:
 * o INTERNAL_ERROR is never generated by the compiler and usually
 *   indicates as error in the heap.
 *   PANIC is generated by the compiler whenever it tests an "irrefutable"
 *   pattern which fails.  If we don't see too many of these, we could
 *   optimise out the redundant test.
 * ------------------------------------------------------------------------*/

typedef enum
    { i_INTERNAL_ERROR  /* Instruction 0 raises an internal error */

    , i_PANIC           /* irrefutable pattern match failed! */

    , i_STK_CHECK
    , i_HP_CHECK

    , i_ARG_CHECK

    , i_ALLOC_AP
    , i_ALLOC_PAP
    , i_ALLOC_CONSTR
    , i_MKAP
    , i_MKPAP
    , i_PACK

    , i_SLIDE

    , i_TEST
    , i_UNPACK

    , i_SEQ

    , i_VAR
    , i_CONST
    , i_ENTER

    , i_RETADDR

    , i_VOID

    , i_VAR_INT
    , i_CONST_INT
    , i_RETURN_INT
    , i_PACK_INT
    , i_UNPACK_INT
    , i_TEST_INT

    , i_VAR_INT64
    , i_CONST_INT64
    , i_RETURN_INT64
    , i_PACK_INT64
    , i_UNPACK_INT64

    , i_VAR_WORD
    , i_CONST_WORD
    , i_RETURN_WORD
    , i_PACK_WORD
    , i_UNPACK_WORD

    , i_VAR_ADDR
    , i_CONST_ADDR
    , i_RETURN_ADDR
    , i_PACK_ADDR
    , i_UNPACK_ADDR

    , i_VAR_CHAR
    , i_CONST_CHAR
    , i_RETURN_CHAR
    , i_PACK_CHAR
    , i_UNPACK_CHAR

    , i_VAR_FLOAT
    , i_CONST_FLOAT
    , i_RETURN_FLOAT
    , i_PACK_FLOAT
    , i_UNPACK_FLOAT

    , i_VAR_DOUBLE
    , i_CONST_DOUBLE
    , i_RETURN_DOUBLE
    , i_PACK_DOUBLE
    , i_UNPACK_DOUBLE

    /* The remaining instructions are the GHC primops */

    , i_raise       
    , i_catch       
    , i_seq

    /* Char# operations */
    , i_gtChar
    , i_geChar
    , i_eqChar
    , i_neChar
    , i_ltChar
    , i_leChar
    , i_charToInt
    , i_intToChar

    /* Int# operations */
    , i_gtInt
    , i_geInt
    , i_eqInt
    , i_neInt
    , i_ltInt
    , i_leInt
    , i_minInt
    , i_maxInt
    , i_plusInt
    , i_minusInt
    , i_timesInt
    , i_quotInt
    , i_remInt
    , i_quotRemInt
    , i_negateInt
    , i_iShiftL
    , i_iShiftRA
    , i_iShiftRL

    /* Int64# operations */
    , i_gtInt64
    , i_geInt64
    , i_eqInt64
    , i_neInt64
    , i_ltInt64
    , i_leInt64
    , i_minInt64
    , i_maxInt64
    , i_plusInt64
    , i_minusInt64
    , i_timesInt64
    , i_quotInt64
    , i_remInt64
    , i_quotRemInt64
    , i_negateInt64
    , i_i64ShiftL
    , i_i64ShiftRA
    , i_i64ShiftRL

    , i_int64ToInt 
    , i_intToInt64 
    , i_int64ToWord 
    , i_wordToInt64 
    , i_int64ToFloat 
    , i_floatToInt64 
    , i_int64ToDouble 
    , i_doubleToInt64 

    /* Word# operations */
    , i_gtWord
    , i_geWord
    , i_eqWord
    , i_neWord
    , i_ltWord
    , i_leWord
    , i_minWord
    , i_maxWord
    , i_and
    , i_or
    , i_not
    , i_shiftL
    , i_shiftRA
    , i_shiftRL
    , i_intToWord
    , i_wordToInt

    /* Addr# operations */
    , i_gtAddr
    , i_geAddr
    , i_eqAddr
    , i_neAddr
    , i_ltAddr
    , i_leAddr
    , i_intToAddr
    , i_addrToInt

    /* Float# operations */
    , i_gtFloat
    , i_geFloat
    , i_eqFloat
    , i_neFloat
    , i_ltFloat
    , i_leFloat
    , i_minFloat
    , i_maxFloat
    , i_radixFloat
    , i_digitsFloat
    , i_minExpFloat
    , i_maxExpFloat
    , i_plusFloat
    , i_minusFloat
    , i_timesFloat
    , i_divideFloat
    , i_negateFloat
    , i_floatToInt
    , i_intToFloat
    , i_expFloat
    , i_logFloat
    , i_sqrtFloat
    , i_sinFloat
    , i_cosFloat
    , i_tanFloat
    , i_asinFloat
    , i_acosFloat
    , i_atanFloat
    , i_sinhFloat
    , i_coshFloat
    , i_tanhFloat
    , i_powerFloat
    , i_decodeFloat
    , i_encodeFloat
    , i_isNaNFloat
    , i_isInfiniteFloat
    , i_isDenormalizedFloat
    , i_isNegativeZeroFloat
    , i_isIEEEFloat

    /* Double# operations */
    , i_gtDouble
    , i_geDouble
    , i_eqDouble
    , i_neDouble
    , i_ltDouble
    , i_leDouble
    , i_minDouble
    , i_maxDouble
    , i_radixDouble
    , i_digitsDouble
    , i_minExpDouble
    , i_maxExpDouble
    , i_plusDouble
    , i_minusDouble
    , i_timesDouble
    , i_divideDouble
    , i_negateDouble
    , i_doubleToInt
    , i_intToDouble
    , i_doubleToFloat
    , i_floatToDouble
    , i_expDouble
    , i_logDouble
    , i_sqrtDouble
    , i_sinDouble
    , i_cosDouble
    , i_tanDouble
    , i_asinDouble
    , i_acosDouble
    , i_atanDouble
    , i_sinhDouble
    , i_coshDouble
    , i_tanhDouble
    , i_powerDouble
    , i_decodeDouble
    , i_encodeDouble
    , i_isNaNDouble
    , i_isInfiniteDouble
    , i_isDenormalizedDouble
    , i_isNegativeZeroDouble
    , i_isIEEEDouble

#if 0
    /* Integer operations */
    , i_compareInteger
    , i_negateInteger
    , i_plusInteger
    , i_minusInteger
    , i_timesInteger
    , i_quotRemInteger
    , i_integerToInt
    , i_intToInteger
    , i_integerToWord
    , i_wordToInteger
    , i_integerToFloat
    , i_floatToInteger
    , i_integerToDouble
    , i_doubleToInteger
#endif

    /* Stateless Addr operations */
    , i_indexCharOffAddr
    , i_indexIntOffAddr
    , i_indexFloatOffAddr
    , i_indexDoubleOffAddr
    , i_indexAddrOffAddr

    /* Immutable array operations */
    , i_indexArray
    , i_indexCharArray
    , i_indexIntArray
    , i_indexFloatArray
    , i_indexDoubleArray
    , i_indexAddrArray

    /* MutVar# operations */
    , i_sameVariable
    , i_writeVar
    , i_readVar

    /* Array# operations */
    , i_sameMutableArray
    , i_sameMutableByteArray

    , i_newArray
    , i_newCharArray
    , i_newIntArray
    , i_newFloatArray
    , i_newDoubleArray
    , i_newAddrArray

    , i_writeArray
    , i_writeCharArray
    , i_writeIntArray
    , i_writeFloatArray
    , i_writeDoubleArray
    , i_writeAddrArray

    , i_readArray
    , i_readCharArray
    , i_readIntArray
    , i_readFloatArray
    , i_readDoubleArray
    , i_readAddrArray

    , i_unsafeFreezeArray
    , i_unsafeFreezeByteArray

    /* ForeignObj# operations */
    , i_makeForeignObj
    , i_writeForeignObj

    /* StablePtr# operations */
    , i_makeStablePtr
    , i_deRefStablePtr

    /* CCall! */
    , i_ccall
} Instr;

typedef unsigned int InstrPtr; /* offset of instruction within BCO */

/*-------------------------------------------------------------------------*/
