/* -----------------------------------------------------------------------------
 * $Id: PrimOps.h,v 1.20 1998/06/02 12:44:42 simonm Exp $
 *
 * Macros for primitive operations in STG-ish C code.
 *
 * ---------------------------------------------------------------------------*/

#ifndef PRIMOPS_H
#define PRIMOPS_H

/* -----------------------------------------------------------------------------
   Comparison PrimOps.
   -------------------------------------------------------------------------- */

#define gtCharZh(r,a,b)	r=(I_)((a)> (b))
#define geCharZh(r,a,b)	r=(I_)((a)>=(b))
#define eqCharZh(r,a,b)	r=(I_)((a)==(b))
#define neCharZh(r,a,b)	r=(I_)((a)!=(b))
#define ltCharZh(r,a,b)	r=(I_)((a)< (b))
#define leCharZh(r,a,b)	r=(I_)((a)<=(b))

/* Int comparisons: >#, >=# etc */
#define ZgZh(r,a,b)	r=(I_)((a) >(b))
#define ZgZeZh(r,a,b)	r=(I_)((a)>=(b))
#define ZeZeZh(r,a,b)	r=(I_)((a)==(b))
#define ZdZeZh(r,a,b)	r=(I_)((a)!=(b))
#define ZlZh(r,a,b)	r=(I_)((a) <(b))
#define ZlZeZh(r,a,b)	r=(I_)((a)<=(b))

#define gtWordZh(r,a,b)	r=(I_)((a) >(b))
#define geWordZh(r,a,b)	r=(I_)((a)>=(b))
#define eqWordZh(r,a,b)	r=(I_)((a)==(b))
#define neWordZh(r,a,b)	r=(I_)((a)!=(b))
#define ltWordZh(r,a,b)	r=(I_)((a) <(b))
#define leWordZh(r,a,b)	r=(I_)((a)<=(b))

#define gtAddrZh(r,a,b)	r=(I_)((a) >(b))
#define geAddrZh(r,a,b)	r=(I_)((a)>=(b))
#define eqAddrZh(r,a,b)	r=(I_)((a)==(b))
#define neAddrZh(r,a,b)	r=(I_)((a)!=(b))
#define ltAddrZh(r,a,b)	r=(I_)((a) <(b))
#define leAddrZh(r,a,b)	r=(I_)((a)<=(b))

#define gtFloatZh(r,a,b)  r=(I_)((a)> (b))
#define geFloatZh(r,a,b)  r=(I_)((a)>=(b))
#define eqFloatZh(r,a,b)  r=(I_)((a)==(b))
#define neFloatZh(r,a,b)  r=(I_)((a)!=(b))
#define ltFloatZh(r,a,b)  r=(I_)((a)< (b))
#define leFloatZh(r,a,b)  r=(I_)((a)<=(b))

/* Double comparisons: >##, >=#@ etc */
#define ZgZhZh(r,a,b)	r=(I_)((a) >(b))
#define ZgZeZhZh(r,a,b)	r=(I_)((a)>=(b))
#define ZeZeZhZh(r,a,b)	r=(I_)((a)==(b))
#define ZdZeZhZh(r,a,b)	r=(I_)((a)!=(b))
#define ZlZhZh(r,a,b)	r=(I_)((a) <(b))
#define ZlZeZhZh(r,a,b)	r=(I_)((a)<=(b))

/*  used by returning comparison primops, defined in Prims.hc. */
extern const StgClosure *PrelBase_Bool_closure_tbl[];

/* -----------------------------------------------------------------------------
   Char# PrimOps.
   -------------------------------------------------------------------------- */

#define ordZh(r,a)	r=(I_)((W_) (a))
#define chrZh(r,a)	r=(StgChar)((W_)(a))

/* -----------------------------------------------------------------------------
   Int# PrimOps.
   -------------------------------------------------------------------------- */

I_ stg_div (I_ a, I_ b);

#define ZpZh(r,a,b)		r=(a)+(b)
#define ZmZh(r,a,b)		r=(a)-(b)
#define ZtZh(r,a,b)		r=(a)*(b)
#define quotIntZh(r,a,b)	r=(a)/(b)
#define ZdZh(r,a,b)		r=ULTRASAFESTGCALL2(I_,(void *, I_, I_),stg_div,(a),(b))
#define remIntZh(r,a,b)		r=(a)%(b)
#define negateIntZh(r,a)	r=-(a)

/* The following operations are the standard add,subtract and multiply
 * except that they return a carry if the operation overflows.
 *
 * They are all defined in terms of 32-bit integers and use the GCC
 * 'long long' extension to get a 64-bit result.  We'd like to use
 * 64-bit integers on 64-bit architectures, but it seems that gcc's
 * 'long long' type is set at 64-bits even on a 64-bit machine.  
 */

#ifdef WORDS_BIGENDIAN
#define C 0
#define R 1
#else
#define C 1
#define R 0
#endif

#define addWithCarryZh(r,c,a,b)			\
{ union { StgInt64 l; StgInt32 i[2]; } z;	\
  z.l = a + b;					\
  r = z.i[R];					\
  c = z.i[C];					\
}

#define subWithCarryZh(r,c,a,b)			\
{ union { StgInt64 l; StgInt32 i[2]; } z;	\
  z.l = a + b;					\
  r = z.i[R];					\
  c = z.i[C];					\
}

#define mulWithCarryZh(r,c,a,b)			\
{ union { StgInt64 l; StgInt32 i[2]; } z;	\
  z.l = a * b;					\
  r = z.i[R];					\
  c = z.i[C];					\
}

/* -----------------------------------------------------------------------------
   Word PrimOps.
   -------------------------------------------------------------------------- */

#define quotWordZh(r,a,b)	r=((W_)a)/((W_)b)
#define remWordZh(r,a,b)	r=((W_)a)%((W_)b)

#define andZh(r,a,b)		r=(a)&(b)
#define orZh(r,a,b)		r=(a)|(b)
#define notZh(r,a)		r=~(a)

#define shiftLZh(r,a,b)	  	r=(a)<<(b)
#define shiftRAZh(r,a,b)  	r=(a)>>(b)
#define shiftRLZh(r,a,b)  	r=(a)>>(b)
#define iShiftLZh(r,a,b)  	r=(a)<<(b)
#define iShiftRAZh(r,a,b) 	r=(a)>>(b)
#define iShiftRLZh(r,a,b) 	r=(a)>>(b)

#define int2WordZh(r,a) 	r=(W_)(a)
#define word2IntZh(r,a) 	r=(I_)(a)

/* -----------------------------------------------------------------------------
   Addr PrimOps.
   -------------------------------------------------------------------------- */

#define int2AddrZh(r,a) 	r=(A_)(a)
#define addr2IntZh(r,a) 	r=(I_)(a)

#define indexCharOffAddrZh(r,a,i)   r= ((C_ *)(a))[i]
#define indexIntOffAddrZh(r,a,i)    r= ((I_ *)(a))[i]
#define indexAddrOffAddrZh(r,a,i)   r= ((PP_)(a))[i]
#define indexFloatOffAddrZh(r,a,i)  r= PK_FLT((P_) (((StgFloat *)(a)) + i))
#define indexDoubleOffAddrZh(r,a,i) r= PK_DBL((P_) (((StgDouble *)(a)) + i))

/* -----------------------------------------------------------------------------
   Float PrimOps.
   -------------------------------------------------------------------------- */

#define plusFloatZh(r,a,b)   r=(a)+(b)
#define minusFloatZh(r,a,b)  r=(a)-(b)
#define timesFloatZh(r,a,b)  r=(a)*(b)
#define divideFloatZh(r,a,b) r=(a)/(b)
#define negateFloatZh(r,a)   r=-(a)
			     
#define int2FloatZh(r,a)     r=(StgFloat)(a)
#define float2IntZh(r,a)     r=(I_)(a)
			     
#define expFloatZh(r,a)	     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,exp,a)
#define logFloatZh(r,a)	     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,log,a)
#define sqrtFloatZh(r,a)     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,sqrt,a)
#define sinFloatZh(r,a)	     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,sin,a)
#define cosFloatZh(r,a)	     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,cos,a)
#define tanFloatZh(r,a)	     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,tan,a)
#define asinFloatZh(r,a)     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,asin,a)
#define acosFloatZh(r,a)     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,acos,a)
#define atanFloatZh(r,a)     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,atan,a)
#define sinhFloatZh(r,a)     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,sinh,a)
#define coshFloatZh(r,a)     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,cosh,a)
#define tanhFloatZh(r,a)     r=(StgFloat) RET_PRIM_STGCALL1(StgDouble,tanh,a)
#define powerFloatZh(r,a,b)  r=(StgFloat) RET_PRIM_STGCALL2(StgDouble,pow,a,b)

/* -----------------------------------------------------------------------------
   Double PrimOps.
   -------------------------------------------------------------------------- */

#define ZpZhZh(r,a,b)	     r=(a)+(b)
#define ZmZhZh(r,a,b)	     r=(a)-(b)
#define ZtZhZh(r,a,b)	     r=(a)*(b)
#define ZdZhZh(r,a,b)	     r=(a)/(b)
#define negateDoubleZh(r,a)  r=-(a)
			     
#define int2DoubleZh(r,a)    r=(StgDouble)(a)
#define double2IntZh(r,a)    r=(I_)(a)
			     
#define float2DoubleZh(r,a)  r=(StgDouble)(a)
#define double2FloatZh(r,a)  r=(StgFloat)(a)
			     
#define expDoubleZh(r,a)     r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,exp,a)
#define logDoubleZh(r,a)     r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,log,a)
#define sqrtDoubleZh(r,a)    r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,sqrt,a)
#define sinDoubleZh(r,a)     r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,sin,a)
#define cosDoubleZh(r,a)     r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,cos,a)
#define tanDoubleZh(r,a)     r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,tan,a)
#define asinDoubleZh(r,a)    r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,asin,a)
#define acosDoubleZh(r,a)    r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,acos,a)
#define atanDoubleZh(r,a)    r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,atan,a)
#define sinhDoubleZh(r,a)    r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,sinh,a)
#define coshDoubleZh(r,a)    r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,cosh,a)
#define tanhDoubleZh(r,a)    r=(StgDouble) RET_PRIM_STGCALL1(StgDouble,tanh,a)
/* Power: **## */
#define ZtZtZhZh(r,a,b)	r=(StgDouble) RET_PRIM_STGCALL2(StgDouble,pow,a,b)

/* -----------------------------------------------------------------------------
   Integer PrimOps.
   -------------------------------------------------------------------------- */

/* We can do integer2Int and cmpInteger inline, since they don't need
 * to allocate any memory.
 */

#define integer2IntZh(r, aa,sa,da)					\
{ MP_INT arg;								\
									\
  arg._mp_alloc	= (aa);							\
  arg._mp_size	= (sa);							\
  arg._mp_d	= (unsigned long int *) (BYTE_ARR_CTS(da));		\
									\
  (r) = RET_PRIM_STGCALL1(I_,mpz_get_si,&arg);				\
}

#define cmpIntegerZh(r, a1,s1,d1, a2,s2,d2)				\
{ MP_INT arg1;								\
  MP_INT arg2;								\
									\
  arg1._mp_alloc= (a1);							\
  arg1._mp_size	= (s1);							\
  arg1._mp_d	= (unsigned long int *) (BYTE_ARR_CTS(d1));		\
  arg2._mp_alloc= (a2);							\
  arg2._mp_size	= (s2);							\
  arg2._mp_d	= (unsigned long int *) (BYTE_ARR_CTS(d2));		\
									\
  (r) = RET_PRIM_STGCALL2(I_,mpz_cmp,&arg1,&arg2);				\
}

/* A glorious hack: calling mpz_neg would entail allocation and
 * copying, but by looking at what mpz_neg actually does, we can
 * derive a better version:
 */

#define negateIntegerZh(ra, rs, rd, a, s, d)				\
{ 									\
  (ra) = (a);								\
  (rs) = -(s);								\
  (rd) = d;								\
}

/* The rest are all out-of-line: -------- */

/* Integer arithmetic */
EF_(plusIntegerZh_fast);
EF_(minusIntegerZh_fast);
EF_(timesIntegerZh_fast);
EF_(quotRemIntegerZh_fast);
EF_(divModIntegerZh_fast);

/* Conversions */
EF_(int2IntegerZh_fast);
EF_(word2IntegerZh_fast);
EF_(addr2IntegerZh_fast);

/* Floating-point encodings/decodings */
EF_(encodeFloatZh_fast);
EF_(decodeFloatZh_fast);

EF_(encodeDoubleZh_fast);
EF_(decodeDoubleZh_fast);

/* -----------------------------------------------------------------------------
   Array PrimOps.
   -------------------------------------------------------------------------- */

#define REAL_BYTE_ARR_CTS(a)   ((C_ *) (((StgArrWords *)(a))->payload))
#define REAL_PTRS_ARR_CTS(a)   ((P_)   (((StgArrPtrs  *)(a))->payload))

#ifdef DEBUG
#define BYTE_ARR_CTS(a)				\
 ({ ASSERT(GET_INFO(a) == &ARR_WORDS_info);	\
    REAL_BYTE_ARR_CTS(a); })
#define PTRS_ARR_CTS(a)				\
 ({ ASSERT((GET_INFO(a) == &ARR_PTRS_info)	\
	|| (GET_INFO(a) == &MUT_ARR_PTRS_info));\
    REAL_PTRS_ARR_CTS(a); })
#else
#define BYTE_ARR_CTS(a)		REAL_BYTE_ARR_CTS(a)
#define PTRS_ARR_CTS(a)		REAL_PTRS_ARR_CTS(a)
#endif

/* Todo: define... */
extern I_ genSymZh(void);
extern I_ resetGenSymZh(void);
extern I_ incSeqWorldZh(void);

extern I_ byteArrayHasNUL__ (const char *, I_);

/*--- everything except new*Array is done inline: */

#define sameMutableArrayZh(r,a,b)	r=(I_)((a)==(b))
#define sameMutableByteArrayZh(r,a,b)	r=(I_)((a)==(b))

#define readArrayZh(r,a,i)	 r=((PP_) PTRS_ARR_CTS(a))[(i)]

#define readCharArrayZh(r,a,i)	 indexCharOffAddrZh(r,BYTE_ARR_CTS(a),i)
#define readIntArrayZh(r,a,i)	 indexIntOffAddrZh(r,BYTE_ARR_CTS(a),i)
#define readAddrArrayZh(r,a,i)	 indexAddrOffAddrZh(r,BYTE_ARR_CTS(a),i)
#define readFloatArrayZh(r,a,i)	 indexFloatOffAddrZh(r,BYTE_ARR_CTS(a),i)
#define readDoubleArrayZh(r,a,i) indexDoubleOffAddrZh(r,BYTE_ARR_CTS(a),i)

/* result ("r") arg ignored in write macros! */
#define writeArrayZh(a,i,v)	((PP_) PTRS_ARR_CTS(a))[(i)]=(v)

#define writeCharArrayZh(a,i,v)	  ((C_ *)(BYTE_ARR_CTS(a)))[i] = (v)
#define writeIntArrayZh(a,i,v)	  ((I_ *)(BYTE_ARR_CTS(a)))[i] = (v)
#define writeAddrArrayZh(a,i,v)	  ((PP_)(BYTE_ARR_CTS(a)))[i] = (v)
#define writeFloatArrayZh(a,i,v)  \
	ASSIGN_FLT((P_) (((StgFloat *)(BYTE_ARR_CTS(a))) + i),v)
#define writeDoubleArrayZh(a,i,v) \
	ASSIGN_DBL((P_) (((StgDouble *)(BYTE_ARR_CTS(a))) + i),v)

#define indexArrayZh(r,a,i)	  r=((PP_) PTRS_ARR_CTS(a))[(i)]

#define indexCharArrayZh(r,a,i)	  indexCharOffAddrZh(r,BYTE_ARR_CTS(a),i)
#define indexIntArrayZh(r,a,i)	  indexIntOffAddrZh(r,BYTE_ARR_CTS(a),i)
#define indexAddrArrayZh(r,a,i)	  indexAddrOffAddrZh(r,BYTE_ARR_CTS(a),i)
#define indexFloatArrayZh(r,a,i)  indexFloatOffAddrZh(r,BYTE_ARR_CTS(a),i)
#define indexDoubleArrayZh(r,a,i) indexDoubleOffAddrZh(r,BYTE_ARR_CTS(a),i)

#define indexCharOffForeignObjZh(r,fo,i)   indexCharOffAddrZh(r,ForeignObj_CLOSURE_DATA(fo),i)
#define indexIntOffForeignObjZh(r,fo,i)    indexIntOffAddrZh(r,ForeignObj_CLOSURE_DATA(fo),i)
#define indexAddrOffForeignObjZh(r,fo,i)   indexAddrOffAddrZh(r,ForeignObj_CLOSURE_DATA(fo),i)
#define indexFloatOffForeignObjZh(r,fo,i)  indexFloatOffAddrZh(r,ForeignObj_CLOSURE_DATA(fo),i)
#define indexDoubleOffForeignObjZh(r,fo,i) indexDoubleOffAddrZh(r,ForeignObj_CLOSURE_DATA(fo),i)

#define indexCharOffAddrZh(r,a,i)   r= ((C_ *)(a))[i]
#define indexIntOffAddrZh(r,a,i)    r= ((I_ *)(a))[i]
#define indexAddrOffAddrZh(r,a,i)   r= ((PP_)(a))[i]
#define indexFloatOffAddrZh(r,a,i)  r= PK_FLT((P_) (((StgFloat *)(a)) + i))
#define indexDoubleOffAddrZh(r,a,i) r= PK_DBL((P_) (((StgDouble *)(a)) + i))

/* Freezing arrays-of-ptrs requires changing an info table, for the
   benefit of the generational collector.  It needs to scavenge mutable
   objects, even if they are in old space.  When they become immutable,
   they can be removed from this scavenge list.	 */

#define unsafeFreezeArrayZh(r,a)					\
	{								\
        SET_INFO((StgClosure *)a,&MUT_ARR_PTRS_FROZEN_info);            \
	r = a;								\
	}

#define unsafeFreezeByteArrayZh(r,a)	r=(a)

#define sizeofByteArrayZh(r,a) \
     r = (((StgArrWords *)(a))->words * sizeof(W_))
#define sizeofMutableByteArrayZh(r,a) \
     r = (((StgArrWords *)(a))->words * sizeof(W_))

/* and the out-of-line ones... */

EF_(newCharArrayZh_fast);
EF_(newIntArrayZh_fast);
EF_(newAddrArrayZh_fast);
EF_(newFloatArrayZh_fast);
EF_(newDoubleArrayZh_fast);
EF_(newArrayZh_fast);

/* encoding and decoding of floats/doubles. */

/* We only support IEEE floating point format */
#include "ieee-flpt.h"

#if FLOATS_AS_DOUBLES  /* i.e. 64-bit machines */
#define encodeFloatZh(r, aa,sa,da, expon)   encodeDoubleZh(r, aa,sa,da, expon)
#else
#define encodeFloatZh(r, aa,sa,da, expon)	\
{ MP_INT arg;					\
  /* Does not allocate memory */		\
						\
  arg._mp_alloc	= aa;				\
  arg._mp_size	= sa;				\
  arg._mp_d	= (unsigned long int *) (BYTE_ARR_CTS(da)); \
						\
  r = RET_PRIM_STGCALL2(StgFloat, __encodeFloat,&arg,(expon));\
}
#endif /* FLOATS_AS_DOUBLES */

#define encodeDoubleZh(r, aa,sa,da, expon)	\
{ MP_INT arg;					\
  /* Does not allocate memory */		\
						\
  arg._mp_alloc	= aa;				\
  arg._mp_size	= sa;				\
  arg._mp_d	= (unsigned long int *) (BYTE_ARR_CTS(da)); \
						\
  r = RET_PRIM_STGCALL2(StgDouble, __encodeDouble,&arg,(expon));\
}

/* The decode operations are out-of-line because they need to allocate
 * a byte array.
 */
 
#ifdef FLOATS_AS_DOUBLES
#define decodeFloatZh_fast decodeDoubleZh_fast
#else
EF_(decodeFloatZh_fast);
#endif

EF_(decodeDoubleZh_fast);

/* grimy low-level support functions defined in StgPrimFloat.c */

extern StgDouble __encodeDouble (MP_INT *s, I_ e);
extern StgFloat  __encodeFloat  (MP_INT *s, I_ e);
extern void      __decodeDouble (MP_INT *man, I_ *_exp, StgDouble dbl);
extern void      __decodeFloat  (MP_INT *man, I_ *_exp, StgFloat flt);

/* -----------------------------------------------------------------------------
   Mutable variables

   newMutVar is out of line.
   -------------------------------------------------------------------------- */

EF_(newMutVarZh_fast);

#define readMutVarZh(r,a)	 r=(P_)(((StgMutVar *)(a))->var)
#define writeMutVarZh(a,v)       (P_)(((StgMutVar *)(a))->var)=(v)
#define sameMutVarZh(r,a,b)      r=(I_)((a)==(b))

/* -----------------------------------------------------------------------------
   MVar PrimOps.

   All out of line, because they either allocate or may block.
   -------------------------------------------------------------------------- */

EF_(newMVarZh_fast);
EF_(takeMVarZh_fast);
EF_(putMVarZh_fast);

/* -----------------------------------------------------------------------------
   Delay/Wait PrimOps
   -------------------------------------------------------------------------- */

/* Hmm, I'll think about these later. */

/* -----------------------------------------------------------------------------
   Primitive I/O, error-handling PrimOps
   -------------------------------------------------------------------------- */

EF_(catchZh_fast);
EF_(raiseZh_fast);

extern void stg_exit(I_ n);

/* ToDo: signal things */

/* -----------------------------------------------------------------------------
   Stable Pointer PrimOps.
   -------------------------------------------------------------------------- */

EF_(makeStablePtrZh_fast);	/* not implemented yet */

/* -----------------------------------------------------------------------------
   Parallel PrimOps.
   -------------------------------------------------------------------------- */

/* Hmm, I'll think about these later. */
EF_(forkZh_fast);
EF_(seqZh_fast);

/* -----------------------------------------------------------------------------
   Pointer equality
   -------------------------------------------------------------------------- */

/* warning: extremely non-referentially transparent, need to hide in
   an appropriate monad.

   ToDo: follow indirections.  
*/

#define reallyUnsafePtrEqualityZh(r,a,b) r=((StgPtr)(a) == (StgPtr)(b))

/* -----------------------------------------------------------------------------
   Foreign Object PrimOps.
   -------------------------------------------------------------------------- */

#define ForeignObj_CLOSURE_DATA(c)  (((StgForeignObj *)c)->data)

EF_(makeForeignObjZh_fast);	/* not implemented yet */

#define writeForeignObjZh(res,datum) \
   (ForeignObj_CLOSURE_DATA(res) = (P_)(datum))
#endif PRIMOPS_H
