/* -----------------------------------------------------------------------------
 * $Id: Profiling.h,v 1.17 1998/05/30 15:15:04 ericw Exp $
 *
 * Cost-Centre Stack Profiling Include
 * ---------------------------------------------------------------------------*/


#ifndef PROFILING_H
#define PROFILING_H

#include <stdio.h>

#if !defined(PROFILING)
  
#define CCS_ALLOC(ccs, amount) doNothing()
#define ENTER_CC_PAP_CL(r)     doNothing(
#define ENTER_CCS_PAP_CL(r)    doNothing()
 
#else /* PROFILING... */


/* -----------------------------------------------------------------------------
 * Constants
 * ---------------------------------------------------------------------------*/

#define EMPTY_STACK NULL
#define EMPTY_TABLE NULL

/* Constants used to set sumbsumed flag on CostCentres */

#define CC_IS_CAF      'c'            /* 'c'  => *is* a CAF cc           */
#define CC_IS_DICT     'd'            /* 'd'  => *is* a dictionary cc    */
#define CC_IS_SUBSUMED 's'            /* 's'  => *is* a subsumed cc      */
#define CC_IS_BORING   'B'            /* 'B'  => *not* a CAF/dict/sub cc */

/* Constants used for abreviated output of data in binary format.  The order
 * is important and corresponds to the "item" elementType in the XML log 
 * description.   */

#define END_TAG 0 
#define CC_TAG 1
#define CCS_TAG 2
#define TYPE_CON_TAG 3
#define HEAP_OBJ_TAG 4
#define TIME_UPDATE_TAG 5
#define HEAP_UPDATE_TAG 6


/* -----------------------------------------------------------------------------
 * Data Structures 
 * ---------------------------------------------------------------------------*/  

typedef struct _IndexTable IndexTable;
typedef struct _CostCentreStack CostCentreStack;

typedef struct _CCDecList CCDecList;
typedef struct _CCSDecList CCSDecList;


/* 
 * CostCentre 
 */

typedef struct {
  int ccID;

  char *label;
  char *module;
  char *group;
 
  char is_subsumed;
} CostCentre;


	
/* 
 * CostCentreStack 
 */

struct _CostCentreStack {
  int ccsID;

  CostCentre *cc;
  CostCentreStack *prevStack;
  IndexTable *ccsIndexTable;
  
  unsigned long scc_count;
  unsigned long sub_cafcc_count;
  unsigned long sub_dictcc_count;
    
  unsigned long time_ticks;
  unsigned long mem_alloc;

  char is_subsumed;  /* inherits value from is_subsumed flag of top CostCentre */
};



/* 
 * IndexTable 
 */

struct _IndexTable {
  CostCentre *cc;
  CostCentreStack *nextStack;
  IndexTable *nextIndexTable;
};

     
/*
 * CCDeclist
 */

struct _CCDecList {
	CostCentre *cc;
	CCDecList *nextList;
};


/*
 * CCSDeclist
 */

struct _CCSDecList {
	CostCentreStack *ccs;
	CCSDecList *nextList;
};






/* Temp to get things going --EW */

extern CostCentreStack *CCCS;
 
extern CostCentre *CC_MAIN;
extern CostCentreStack *CCS_MAIN;

extern CostCentre *CC_GC;
extern CostCentreStack *CCS_GC;

extern CostCentre *CC_OVERHEAD;
extern CostCentreStack *CCS_OVERHEAD;

/* extern CostCentre *CC_DONTZuCARE; */
/*extern CostCentreStack *CCS_DONTZuCARE;   */
#define CCS_DONTZuCARE 0  /* temp EW */

extern I_ interval_ticks;
extern I_ earlier_ticks;

typedef StgWord hash_t;
extern hash_t time_intervals;

/* In RtsFlags.c, these are used to specify how to hash the data for 
 * output.  None of this is necessary now since the viewer will be in 
 * charge of ordering and displaying output.  */
extern hash_t max_cc_no;                        /* Hash on CC ptr */
extern hash_t max_mod_no;                       /* Hash on CC module */
extern hash_t max_grp_no;                       /* Hash on CC group */
extern hash_t max_descr_no;                     /* Hash on closure description */
extern hash_t max_type_no;                      /* Hash on type description */



# define TICK_FREQUENCY   50                      /* ticks per second */
# define TICK_MILLISECS   (1000/TICK_FREQUENCY)   /* ms per tick */
 
# define DEFAULT_INTERVAL TICK_FREQUENCY


#define CCS_HDR_SIZE 1

#define PROF_FIXED_HDR                  (CCS_HDR_SIZE)   
#define TICKY_FIXED_HDR                 (TICKY_HDR_SIZE)

#define GRAB_CCS(frame) \
 (CostCentreStack *)((StgUpdateFrame *)(frame))->header.prof.ccs

#define RTBL_SuB            (BaseReg->rSu)
#define SuB RTBL_SuB



/* Maybe temp to get going --EW */





/* -----------------------------------------------------------------------------
 * Functions 
 * ---------------------------------------------------------------------------*/

void initProfiling ( void );

CostCentre *DeclareCC ( char *, char *, char *, char );

CostCentreStack *NewCostCentreStack ( void );
CostCentreStack *PushCostCentre ( CostCentreStack *, CostCentre * );
CostCentreStack *ActualPush ( CostCentreStack *, CostCentre * );
CostCentreStack *RemoveCC ( CostCentreStack *, CostCentre * );

CostCentreStack *IsInIndexTable ( IndexTable *, CostCentre * );
IndexTable *AddToIndexTable ( IndexTable *, CostCentreStack *, CostCentre * );

void report_ccs_profiling ( void );
void heap_profile_finish (void);

void PrintNewCCDecls ( void );
void PrintNewStackDecls ( void );

void PrintTimeSample ( void );
void PrintHeapSample ( void );

void PrintNonZeroTimeStats ( void );
void PrintNonZeroHeapStats ( void );

void print_ccs (FILE *, CostCentreStack *);

void DecCC(CostCentre *cc);
void DecCCS(CostCentreStack *ccs);

/* -----------------------------------------------------------------------------
 * Macros
 * ---------------------------------------------------------------------------*/

#define CCS_TICK(ccs)  ccs->time_ticks++
#define CCS_ALLOC(ccs, size) ccs->mem_alloc += (size) - (PROF_FIXED_HDR + TICKY_FIXED_HDR)

#define ENTER_SCC(ccs)          ccs->scc_count++
#define ENTER_SUB_SCC(ccs)      ccs->sub_scc_count++

#define TOP(ccs)  ccs->cc
#define PREV(ccs) ccs->prevStack

#define ASSIGN_CC_ID(ccID)                \
        do {                              \
        ccID = CC_ID;                     \
        CC_ID++;                          \
        } while(0)

#define ASSIGN_CCS_ID(ccsID)              \
        do {                              \
        ccsID = CCS_ID;                   \
        CCS_ID++;                         \
        } while(0)

#define ASSIGN_HP_ID(hpID)                \
        do {                              \
        hpID = HP_ID;                     \
        HP_ID++;                          \
        } while(0)

#define SET_STATS_TO_ZERO(stack)          \
        do {                              \
        (stack)->scc_count = 0;           \
        (stack)->time_ticks = 0;          \
        (stack)->sub_cafcc_count = 0;     \
        (stack)->sub_dictcc_count = 0;    \
        (stack)->mem_alloc = 0;           \
        } while(0)
        

#if defined(PROFILING_DETAIL_COUNTS)
#define CCCS_DETAIL_COUNT(inc_this) ((inc_this)++)
#else
#define CCCS_DETAIL_COUNT(inc_this) /*nothing*/
#endif

#define IS_CAF_OR_DICT_OR_SUB_CCS(ccs)         \
        /* tests for lower case character */   \
        ((ccs)->is_subsumed & ' ')
	

# define SET_CCS_HDR(closure, ccs_) \
         (closure)->header.prof.ccs = (CostCentreStack *)(ccs_)


/* On entry to top level CAFs we count the scc ...*/

#define ENTER_CCS_CAF_X(ccs)                                \
        do {                                                \
        /* inc subcaf count of CCCS */                      \
        CCCS->sub_cafcc_count++;                            \
        /* set CCCS to ident ccs */                         \
        CCCS = (CostCentreStack *)(ccs);                    \
        /* inc scc count of CAF ccs */                      \
        CCCS->scc_count++;                                  \
        } while(0)
 
#define ENTER_CCS_CAF(ccs_ident)   ENTER_CCS_CAF_X(STATIC_CCS_REF(ccs_ident))
#define ENTER_CCS_CAF_CL(closure) ENTER_CCS_CAF_X((closure)->header.prof.ccs)

/* On entering a closure we only count the enter to thunks ...  */

#define ENTER_CCS_T(ccs)                                    \
        do {                                                \
        CCCS = (CostCentreStack *)(ccs);                    \
        CCCS_DETAIL_COUNT(CCCS->thunk_count);               \
        } while(0)      
 
#define ENTER_CCS_TCL(closure)                              \
        ENTER_CCS_T((closure)->header.prof.ccs)
 
/* Here is our special "hybrid" case when we do *not* set the CCCS.
   (a) The closure is a function, not a thunk;
   (b) The CCS is CAF/DICT-ish.
*/

#define ENTER_CCS_F(stack)                                  \
        do {                                                \
        CostCentreStack *ccs = (CostCentreStack *) (stack); \
        if ( ! IS_CAF_OR_DICT_OR_SUB_CCS(ccs) ) {           \
           CCCS = ccs;                                      \
        } else {                                            \
           CCCS_DETAIL_COUNT(ccs->caffun_subsumed);         \
           CCCS_DETAIL_COUNT(CCCS->subsumed_caf_count);     \
        }                                                   \
        CCCS_DETAIL_COUNT(CCCS->function_count);            \
        } while(0)
 
#define ENTER_CCS_FCL(closure)                              \
        ENTER_CCS_F((closure)->header.prof.ccs)
 
#define ENTER_CCS_FSUB()                                    \
        do {                                                \
        CCCS_DETAIL_COUNT(CCCS->subsumed_fun_count);        \
        CCCS_DETAIL_COUNT(CCCS->function_count);            \
        } while(0)
 
#define ENTER_CCS_FCAF(stack)                               \
        do {                                                \
        CostCentreStack *ccs = (CostCentreStack *) (stack); \
        CCCS_DETAIL_COUNT(ccs->caffun_subsumed);            \
        CCCS_DETAIL_COUNT(CCCS->subsumed_caf_count);        \
        CCCS_DETAIL_COUNT(CCCS->function_count);            \
        } while(0)
 
#define ENTER_CCS_FLOAD(ccs)                                \
        do {                                                \
        CCCS = (CostCentreStack *)(ccs);                    \
        CCCS_DETAIL_COUNT(CCCS->function_count);            \
        } while(0)
 
/* These ENTER_CC_PAP things are only used in the RTS */
 
#define ENTER_CCS_PAP(stack)                                \
        do {                                                \
        CostCentreStack *ccs = (CostCentreStack *) (stack); \
        if ( ! IS_CAF_OR_DICT_OR_SUB_CCS(ccs) ) {           \
            CCCS = ccs;                                     \
        } else {                                            \
            CCCS_DETAIL_COUNT(ccs->caffun_subsumed);        \
            CCCS_DETAIL_COUNT(CCCS->subsumed_caf_count);    \
        }                                                   \
        CCCS_DETAIL_COUNT(CCCS->pap_count);                 \
        } while(0)                      

#define ENTER_CCS_PAP_CL(closure)  \
        ENTER_CCS_PAP((closure)->header.prof.ccs)

 


/* temp EW */
#define STATIC_CCS_REF(ccs) (ccs)

/* temp EW */
/* make initialize_virtual_timer visible to the world */
int initialize_virtual_timer( int ms);

#endif /*Profiling*/

#endif PROFILING_H
