/* -----------------------------------------------------------------------------
 * $Id: Rts.h,v 1.12 1998/05/16 02:26:33 reid Exp $
 *
 * Top-level include file for the RTS itself
 *
 * ---------------------------------------------------------------------------*/

#ifndef RTS_H
#define RTS_H

#ifndef NO_REGS
#define NO_REGS			/* don't define fixed registers */
#endif
#include "Stg.h"

/* -----------------------------------------------------------------------------
   Miscellaneous garbage
   -------------------------------------------------------------------------- */

#if ! defined(EXIT_SUCCESS) || ! defined(EXIT_FAILURE)
/* "stdlib.h" should have defined these; but at least
   on SunOS 4.1.3, this is not so.
*/
#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1
#endif

/* declarations for runtime flags/values */
#define MAX_RTS_ARGS 32

/* -----------------------------------------------------------------------------
   Useful typedefs
   -------------------------------------------------------------------------- */

typedef unsigned int  nat;           // at least 32 bits (like int)
typedef unsigned long lnat;          // at least 32 bits
typedef unsigned long long ullong;   // at least 32 bits
  
typedef enum { 
    rtsFalse = 0, 
    rtsTrue 
} rtsBool;

/* -----------------------------------------------------------------------------
   Assertions and Debuggery
   -------------------------------------------------------------------------- */

#ifndef DEBUG
#define ASSERT(predicate) /* nothing */
#else

void _stgAssert (char *, unsigned int);

#define ASSERT(predicate)			\
	if (predicate)				\
	    /*null*/;				\
	else					\
	    _stgAssert(__FILE__, __LINE__)

#endif /* DEBUG */

#ifndef DEBUG
#define IF_DEBUG(c,s)  doNothing()
#else
#define IF_DEBUG(c,s)  if (RtsFlags.DebugFlags.c) { s; }
#endif

/* -----------------------------------------------------------------------------
   Useful macros and inline functions
   -------------------------------------------------------------------------- */

/* 
 * Use this on the RHS of macros which expand to nothing
 * to make sure that the macro can be used in a context which
 * demands a non-empty statement.
 */

#define doNothing() do { } while (0)

static inline int stg_min(int x, int y) { return x <= y ? x : y; }
static inline int stg_max(int x, int y) { return x <= y ? y : x; }

#endif RTS_H
