/* -----------------------------------------------------------------------------
 * $Id: StorageDefs.h,v 1.6 1998/05/22 03:18:53 reid Exp $
 *
 * Storage-related definitions.
 *
 * ---------------------------------------------------------------------------*/

#ifndef STORAGEDEFS_H
#define STORAGEDEFS_H

typedef struct {
    P_ hp;	/* last successfully allocated word */
    P_ hplim;   /* last allocatable word */

#ifndef PAR
    StgForeignObj *ForeignObjList; /* List of all Foreign objects */
    P_ StablePointerTable;	/* In the heap. */
#endif /* !PAR */

    StgClosure* CafList;
} smInfo;

extern smInfo StorageMgrInfo;

/* temporary measure until SRTs are implemented */
void newCAF(StgClosure*);

/* Storage Manager interface to Foreign Objects: */

#ifdef DEBUG
extern void checkValidForeignObjList (StgForeignObj *);
extern void trashForeignObj (StgForeignObj *);
#else
#define checkValidForeignObjList(fo) /* nothing */
#define trashForeignObj(fo)          /* nothing */
#endif

extern void newForeignObj(StgForeignObj *);

#endif STORAGEDEFS_H
