/* -----------------------------------------------------------------------------
 * $Id: TSO.h,v 1.8 1998/05/21 13:13:56 ericw Exp $
 *
 * The definitions for Thread State Objects.
 *
 * ---------------------------------------------------------------------------*/

#ifndef TSO_H
#define TSO_H

#if defined(PROFILING)
typedef struct {
  StgWord CCCS;
} StgTSOProfInfo;
#else /* !PROFILING */
typedef struct {
} StgTSOProfInfo;
#endif /* PROFILING */

#if defined(PAR)
typedef struct {
} StgTSOParInfo;
#else /* !PAR */
typedef struct {
} StgTSOParInfo;
#endif /* PAR */

#if defined(TICKY)
typedef struct {
} StgTSOTickyInfo;
#else /* !TICKY */
typedef struct {
} StgTSOTickyInfo;
#endif /* TICKY */

typedef enum {
    tso_state_runnable,
    tso_state_stopped
} StgTSOState;

typedef enum {
  ThreadEnterGHC,
  ThreadRunGHC,
  ThreadEnterHugs
} StgTSOWhatNext;

/*
 * This type is returned to the scheduler by a thread that has
 * stopped for one reason or another.
 */

typedef enum {
  HeapOverflow,			/* might also be StackOverflow */
  StackOverflow,
  ThreadYielding,
  ThreadBlocked,
  ThreadFinished
} StgThreadReturnCode;

/* TSOs live on the heap, and therefore look just like heap objects. */

typedef struct StgTSO_ {
  StgHeader          header;
  struct StgTSO_*    link;
  StgTSOWhatNext     whatNext;
  StgTSOState        state;	/* necessary? */
  /* Exception Handlers */
  StgTSOTickyInfo    ticky; 
  StgTSOProfInfo     prof;
  StgTSOParInfo      par;
  /* GranSim Info? */

  /* The thread stack... */
  W_    	     stack_size;   /* stack size in *words* */
  P_                 sp;
  StgUpdateFrame*    su;
  P_                 splim;
  StgWord            stack[0];
} StgTSO;

extern StgTSO      *CurrentTSO;

#endif /* TSO_H */
