/* -*- mode: hugs-c; -*- */
/* -----------------------------------------------------------------------------
 * Bytecode assembler
 *
 * Copyright (c) 1994-1998.
 *
 * $RCSfile: Assembler.h,v $
 * $Revision: 1.10 $
 * $Date: 1998/05/27 23:37:11 $
 *
 * NB This is one of the few files shared between Hugs and the runtime system,
 * so it is very important that it not conflict with either and that it not
 * rely on either.  
 * (In fact, it might be fun to create a GreenCard interface to this file too.)
 * ---------------------------------------------------------------------------*/

// ToDo: put this somewhere more sensible
extern void DEBUG_LoadSymbols( char *name );

// 'type' of variables and constants
typedef enum {
  ILLEGAL_REP,
  VOID_REP,      
  INT_REP,      
  INT64_REP,  
  WORD_REP,     
  ADDR_REP,     
  CHAR_REP,     
  FLOAT_REP,    
  DOUBLE_REP,   
  PTR_REP,       
} AsmRep;

typedef unsigned char   AsmNat8;
typedef unsigned int    AsmNat;
typedef signed   int    AsmInt;
typedef signed long int AsmInt64;  // ToDo: not portable!
typedef unsigned int    AsmWord;
typedef void*           AsmAddr;
typedef unsigned char   AsmChar;
typedef float           AsmFloat;  // ToDo: not on Alphas!
typedef double          AsmDouble;

// I want to #include this file into the file that defines the
// functions but I don't want to expose the structures that
// these types point to.
// This hack is the best I could think of.  Surely there's a better way?
#ifdef INSIDE_ASSEMBLER_C
typedef struct AsmObject_* AsmObject;
typedef struct AsmBCO_*    AsmBCO;
typedef struct AsmCon_*    AsmCon;
typedef struct AsmAP_*     AsmAP;
typedef StgInfoTable*      AsmInfo;
typedef StgClosure*        AsmClosure;
typedef Instr              AsmInstr;
#else
// the types we export are totally opaque
typedef void* AsmObject;
typedef void* AsmBCO;
typedef void* AsmCon;
typedef void* AsmAP;
typedef void* AsmInfo;
typedef void* AsmClosure;
typedef unsigned int AsmInstr;
#endif

typedef int   AsmSp;   // stack offset
typedef int   AsmPc;   // program counter
typedef AsmSp AsmVar;  // offset of a Var on the stack

/* --------------------------------------------------------------------------
 * Allocating (top level) heap objects
 * ------------------------------------------------------------------------*/

extern AsmBCO     asmBeginBCO        ( void );
extern void       asmEndBCO          ( AsmBCO bco );

extern AsmAP      asmBeginAP         ( void );
extern void       asmEndAP           ( AsmAP ap );

extern AsmInfo    asmMkInfo          ( AsmNat tag, AsmNat ptrs, AsmNat nptrs );
extern AsmCon     asmBeginCon        ( AsmInfo info );
extern void       asmEndCon          ( AsmCon con );

//extern AsmObject  asmStringObj       ( const char* s );

extern void       asmAddPtr          ( AsmObject obj, AsmObject arg );

extern AsmClosure asmClosureOfObject ( AsmObject obj );

/* --------------------------------------------------------------------------
 * Generating instruction streams
 * ------------------------------------------------------------------------*/
                               
extern AsmSp  asmBeginArgCheck ( AsmBCO bco );
extern void   asmEndArgCheck   ( AsmBCO bco, AsmSp last_arg );
                               
extern AsmSp  asmBeginEnter    ( AsmBCO bco );
extern void   asmEndEnter      ( AsmBCO bco, AsmSp sp1, AsmSp sp2 );
                               
extern AsmVar asmBind          ( AsmBCO bco, AsmRep rep );
extern void   asmVar           ( AsmBCO bco, AsmVar v, AsmRep rep );
                               
extern AsmSp  asmBeginCase         ( AsmBCO bco );
extern void   asmEndCase           ( AsmBCO bco );
extern AsmSp  asmContinuation      ( AsmBCO bco, AsmBCO ret_addr );
extern AsmBCO asmBeginContinuation ( AsmSp sp );
extern void   asmEndContinuation   ( AsmBCO bco );
                               
extern AsmSp  asmBeginAlt      ( AsmBCO bco );
extern void   asmEndAlt        ( AsmBCO bco, AsmSp  sp );
extern AsmPc  asmTest          ( AsmBCO bco, AsmWord tag );
extern AsmPc  asmTestInt       ( AsmBCO bco, AsmVar v, AsmInt x );
extern void   asmFixBranch     ( AsmBCO bco, AsmPc pc );
extern void   asmPanic         ( AsmBCO bco );
                               
// build boxed Ints, Floats, etc
extern AsmVar asmPackInt       ( AsmBCO bco );
extern AsmVar asmPackAddr      ( AsmBCO bco );
extern AsmVar asmPackWord      ( AsmBCO bco );
extern AsmVar asmPackChar      ( AsmBCO bco );
extern AsmVar asmPackFloat     ( AsmBCO bco );
extern AsmVar asmPackDouble    ( AsmBCO bco );
extern AsmVar asmPackInt64     ( AsmBCO bco );
             
// unbox Ints, Floats, etc
extern AsmVar asmUnpackInt     ( AsmBCO bco );
extern AsmVar asmUnpackAddr    ( AsmBCO bco );
extern AsmVar asmUnpackWord    ( AsmBCO bco );
extern AsmVar asmUnpackChar    ( AsmBCO bco );
extern AsmVar asmUnpackFloat   ( AsmBCO bco );
extern AsmVar asmUnpackDouble  ( AsmBCO bco );
extern AsmVar asmUnpackInt64   ( AsmBCO bco );
        
// push unboxed Ints, Floats, etc
extern void   asmConstInt      ( AsmBCO bco, AsmInt     x );
extern void   asmConstAddr     ( AsmBCO bco, AsmAddr    x );
extern void   asmConstWord     ( AsmBCO bco, AsmWord    x );
extern void   asmConstChar     ( AsmBCO bco, AsmChar    x );
extern void   asmConstFloat    ( AsmBCO bco, AsmFloat   x );
extern void   asmConstDouble   ( AsmBCO bco, AsmDouble  x );
extern void   asmConstInt64    ( AsmBCO bco, AsmInt64   x );
             
// return unboxed Ints, Floats, etc
extern void   asmReturnInt     ( AsmBCO bco );
extern void   asmReturnAddr    ( AsmBCO bco );
extern void   asmReturnWord    ( AsmBCO bco );
extern void   asmReturnChar    ( AsmBCO bco );
extern void   asmReturnFloat   ( AsmBCO bco );
extern void   asmReturnDouble  ( AsmBCO bco );
extern void   asmReturnInt64   ( AsmBCO bco );

/* Which monad (if any) does the primop live in? */
typedef enum {
    MONAD_Id,  // no monad (aka the identity monad)
    MONAD_ST,
    MONAD_IO
} AsmMonad;

typedef struct {
    char*    name;
    char*    args;
    char*    results;
    AsmMonad monad;
    AsmNat8  opcode; // should be StgInstr
} AsmPrim;

extern AsmPrim asmPrimOps[]; // null terminated list

extern AsmPrim* asmFindPrim    ( char* s );
extern AsmPrim* asmFindOpcode  ( AsmInstr op );
extern AsmSp    asmBeginPrim   ( AsmBCO bco );
extern void     asmEndPrim     ( AsmBCO bco, AsmPrim* prim, AsmSp base );

/* --------------------------------------------------------------------------
 * Heap manipulation
 * ------------------------------------------------------------------------*/

extern AsmVar asmClosure       ( AsmBCO bco, AsmObject p );

extern AsmVar asmAllocCONSTR   ( AsmBCO bco, AsmInfo info );
extern void   asmPack          ( AsmBCO bco, AsmVar v, AsmInfo info );

extern void   asmBeginUnpack   ( AsmBCO bco );
extern void   asmEndUnpack     ( AsmBCO bco );

extern AsmVar asmAllocAP       ( AsmBCO bco, AsmNat size );
extern AsmSp  asmBeginMkAP     ( AsmBCO bco );
extern void   asmEndMkAP       ( AsmBCO bco, AsmVar v, AsmSp start );

extern AsmVar asmAllocPAP      ( AsmBCO bco, AsmNat size );
extern AsmSp  asmBeginMkPAP    ( AsmBCO bco );
extern void   asmEndMkPAP      ( AsmBCO bco, AsmVar v, AsmSp start );

/* --------------------------------------------------------------------------
 * C-call and H-call
 * ------------------------------------------------------------------------*/

extern AsmPrim ccall_prim;

typedef struct {
  char *        arg_tys;
  int           arg_size;
  char *        result_tys;
  int           result_size;
} CFunDescriptor;

typedef struct {
  char *        arg_tys;
  char *        result_tys;
} HFunDescriptor;

CFunDescriptor* mkDescriptor( char* as, char* rs );

/*-------------------------------------------------------------------------*/




