#ifdef DEBUG
/* debugging routines */
extern void checkHeap  ( StgPtr hp_start, StgPtr hp_end);
extern void checkStack ( StgPtr hp_start, StgPtr hp_end, StgStackPtr sp, StgStackPtr stack_end, StgUpdateFrame* su );
extern void checkTSO   ( StgPtr hp_start, StgPtr hp_end, StgTSO *tso );

extern StgOffset checkClosure( StgPtr hp_start, StgPtr hp_end, StgClosure* p );


/*
 * We use some symbols inserted automatically by the linker to decide
 * whether a pointer points to text, data, or user space.  These tests
 * assume that text is lower in the address space than data, which in
 * turn is lower than user allocated memory.  
 *
 * If this assumption is false (say on some strange architecture) then
 * the tests IS_CODE_PTR and IS_DATA_PTR below will need to be
 * modified (and that should be all that's necessary).
 *
 * _start      } start of read-only text space
 * _etext      } end   of read-only text space
 * _end } end of read-write data space 
 */
extern StgFun start, etext, end;

#define IS_CODE_PTR(p) ((P_)(p) < (P_)etext)
#define IS_DATA_PTR(p) ((P_)(p) >= (P_)etext && (P_)(p) < (P_)end)

#endif /* DEBUG */
 
