/* -----------------------------------------------------------------------------
 * $Id: Schedule.h,v 1.7 1998/06/04 15:18:05 simonm Exp $
 *
 * Prototypes for functions in Schedule.c
 *
 * ---------------------------------------------------------------------------*/

void    initScheduler(void);
void    schedule(void);

StgTSO *createMainThread(nat stack_size,  const StgClosure *closure_to_enter);

void initIOThread(StgTSO *tso, nat stack_size, 
		  const StgClosure *closure_to_enter);
void initGenThread(StgTSO *tso, nat stack_size, 
		   const StgClosure *closure_to_enter);

void    deleteThread(StgTSO *tso);

void awaken_blocked_queue(StgTSO *q);

extern  nat context_switch;

extern  StgTSO *run_queue_hd, *run_queue_tl;
extern  StgTSO *blocked_queue_hd, *blocked_queue_tl;

#define END_TSO_QUEUE  ((StgTSO *)&END_TSO_QUEUE_closure)

#define PUSH_ON_RUN_QUEUE(tso)			\
    if (run_queue_hd == END_TSO_QUEUE) {        \
      run_queue_hd = tso;			\
    } else {					\
      run_queue_tl->link = tso;			\
    }						\
    run_queue_tl = tso;
