/* -----------------------------------------------------------------------------
 * $Id: StgRun.h,v 1.6 1998/05/15 12:52:02 ericw Exp $
 *
 * Tiny assembler 'layer' between the C and STG worlds.
 * 
 ---------------------------------------------------------------------------- */

extern StgThreadReturnCode StgRun(StgFunPtr f);
EXTFUN(StgReturn);

/* -----------------------------------------------------------------------------
   Saving context for exit from the STG world.

   We save all the STG registers (that is, the ones that are mapped to
   machine registers) in their places in the TSO.  

   The stack registers go into the current stack object, and the heap
   registers are saved in global locations.
   -------------------------------------------------------------------------- */

static __inline__ void
SaveThreadState(void)
{
  /* Don't need to save REG_Base, it won't have changed. */

  CurrentTSO->sp       = Sp;
  CurrentTSO->su       = Su;
  CurrentTSO->splim    = SpLim;
  StorageMgrInfo.hp    = Hp;
  StorageMgrInfo.hplim = HpLim;
}

static __inline__ void 
LoadThreadState (void)
{
#ifdef REG_Base
  BaseReg = &MainRegTable;
#endif

  Sp    = CurrentTSO->sp;
  Su    = CurrentTSO->su;
  SpLim = CurrentTSO->splim;
  Hp	= StorageMgrInfo.hp;
  HpLim = StorageMgrInfo.hplim;

# if defined(PROFILING) || defined(PAR)
  CCCS = (CostCentreStack *)CurrentTSO->prof.CCCS;
# endif
}
