/* -----------------------------------------------------------------------------
 * $Id: StgStdThunks.hc,v 1.6 1998/05/19 19:14:17 reid Exp $
 *
 * Canned "Standard Form" Thunks
 *
 * ---------------------------------------------------------------------------*/

#include "Stg.h"

/* -----------------------------------------------------------------------------
   The code for a thunk that simply extracts a field from a
   single-constructor datatype depends only on the offset of the field
   to be selected.

   Here we define some canned "selector" thunks that do just that; any
   selector thunk appearing in a program will refer to one of these
   instead of being compiled independently.

   The garbage collector spots selector thunks and reduces them if
   possible, in order to avoid space leaks resulting from lazy pattern
   matching.
   -------------------------------------------------------------------------- */

#define SELECTOR_CODE_UPD(offset) \
  IF_(__sel_ret_##offset##_upd_ret);					\
  INFO_TABLE_SRT_BITMAP(__sel_ret_##offset##_upd_info,__sel_ret_##offset##_upd_ret, 0, 0, 0, 0, RET_SMALL, static const, IF_, 0, 0);					\
  IF_(__sel_ret_##offset##_upd_ret) {					\
    FB_									\
      R1.p=(P_)R1.p[offset+1];						\
      Sp=Sp+1;								\
      JMP_(ENTRY_CODE(*R1.p));						\
    FE_									\
  }									\
									\
  EF_(__sel_##offset##_upd_entry);					\
  INFO_TABLE_SELECTOR(__sel_##offset##_upd_info, __sel_##offset##_upd_entry, offset, const, IF_, 0,0);\
  									\
  EF_(__sel_##offset##_upd_entry) {					\
    FB_									\
      STK_CHK(4,__sel_##offset##_upd_entry,R2.p,1,);			\
      UPD_BH_UPDATABLE(R1.p);						\
      PUSH_UPD_FRAME(R1.p,0);						\
      Sp[-4]=(W_)__sel_ret_##offset##_upd_ret;				\
      R1.p = (P_)R1.p[1];						\
      Sp=Sp-4;								\
      JMP_(ENTRY_CODE(*R1.p));						\
    FE_									\
  }

SELECTOR_CODE_UPD(0);
SELECTOR_CODE_UPD(1);
SELECTOR_CODE_UPD(2);
SELECTOR_CODE_UPD(3);
SELECTOR_CODE_UPD(4);
SELECTOR_CODE_UPD(5);
SELECTOR_CODE_UPD(6);
SELECTOR_CODE_UPD(7);
SELECTOR_CODE_UPD(8);
SELECTOR_CODE_UPD(9);
SELECTOR_CODE_UPD(10);
SELECTOR_CODE_UPD(11);
SELECTOR_CODE_UPD(12);
SELECTOR_CODE_UPD(13);
SELECTOR_CODE_UPD(14);
SELECTOR_CODE_UPD(15);

#define SELECTOR_CODE_NOUPD(offset) \
  IF_(__sel_ret_##offset##_noupd_ret);					\
  INFO_TABLE_SRT_BITMAP(__sel_ret_##offset##_noupd_info, __sel_ret_##offset##_noupd_ret, 0, 0, 0, 0, RET_SMALL, static const, IF_, 0, 0);		\
  IF_(__sel_ret_##offset##_noupd_ret) {					\
    FB_									\
      R1.p=(P_)R1.p[offset+1];						\
      Sp=Sp+1;								\
      JMP_(ENTRY_CODE(*R1.p));						\
    FE_									\
  }									\
									\
  EF_(__sel_##offset##_noupd_entry);					\
  INFO_TABLE_SELECTOR(__sel_##offset##_noupd_info, __sel_##offset##_noupd_entry, offset, const, IF_, 0,0);\
  EF_(__sel_##offset##_noupd_entry) {					\
    FB_									\
      STK_CHK(1,__sel_##offset##_noupd_entry,R2.p,1,);			\
      Sp[-1]=(W_)__sel_ret_##offset##_noupd_ret;				\
      R1.p = (P_)R1.p[1];						\
      Sp=Sp-1;								\
      JMP_(ENTRY_CODE(*R1.p));						\
    FE_									\
  }

SELECTOR_CODE_NOUPD(0);
SELECTOR_CODE_NOUPD(1);
SELECTOR_CODE_NOUPD(2);
SELECTOR_CODE_NOUPD(3);
SELECTOR_CODE_NOUPD(4);
SELECTOR_CODE_NOUPD(5);
SELECTOR_CODE_NOUPD(6);
SELECTOR_CODE_NOUPD(7);
SELECTOR_CODE_NOUPD(8);
SELECTOR_CODE_NOUPD(9);
SELECTOR_CODE_NOUPD(10);
SELECTOR_CODE_NOUPD(11);
SELECTOR_CODE_NOUPD(12);
SELECTOR_CODE_NOUPD(13);
SELECTOR_CODE_NOUPD(14);
SELECTOR_CODE_NOUPD(15);

/* -----------------------------------------------------------------------------
   Apply thunks
   -------------------------------------------------------------------------- */

FN_(__ap_1_upd_entry);
FN_(__ap_2_upd_entry);
FN_(__ap_3_upd_entry);
FN_(__ap_4_upd_entry);
FN_(__ap_5_upd_entry);
FN_(__ap_6_upd_entry);
FN_(__ap_7_upd_entry);
FN_(__ap_8_upd_entry);

/* __ap_1_upd_info is a bit redundant, but there appears to be a bug
 * in the compiler that means __ap_1 is generated occasionally (ToDo)
 */

INFO_TABLE_SRT(__ap_1_upd_info,__ap_1_upd_entry,1,0,0,0,0,THUNK,const,IF_,0,0);
FN_(__ap_1_upd_entry) {
  FB_
  STK_CHK_NP(3,1,);
  UPD_BH_UPDATABLE(R1.p);
  PUSH_UPD_FRAME(R1.p,0);
  R1.p=(P_)(R1.p[1]);
  Sp=Sp-4;
  JMP_(ENTRY_CODE(*R1.p));
  FE_
}

INFO_TABLE_SRT(__ap_2_upd_info,__ap_2_upd_entry,2,0,0,0,0,THUNK,const,IF_,0,0);
FN_(__ap_2_upd_entry) {
  FB_
  STK_CHK_NP(4,1,);
  UPD_BH_UPDATABLE(R1.p);
  PUSH_UPD_FRAME(R1.p,0);
  Sp[-4]=(W_)(R1.p[2]);
  R1.p=(P_)(R1.p[1]);
  Sp=Sp-4;
  JMP_(ENTRY_CODE(*R1.p));
  FE_
}

INFO_TABLE_SRT(__ap_3_upd_info,__ap_3_upd_entry,3,0,0,0,0,THUNK, const,IF_,0,0);
FN_(__ap_3_upd_entry) {
  FB_
  STK_CHK_NP(5,1,);
  UPD_BH_UPDATABLE(R1.p);
  PUSH_UPD_FRAME(R1.p,0);
  Sp[-4]=(W_)(R1.p[3]);
  Sp[-5]=(W_)(R1.p[2]);
  R1.p=(P_)(R1.p[1]);
  Sp=Sp-5;
  JMP_(ENTRY_CODE(*R1.p));
  FE_
}

INFO_TABLE_SRT(__ap_4_upd_info,__ap_4_upd_entry,4,0,0,0,0,THUNK, const,IF_,0,0);
FN_(__ap_4_upd_entry) {
  FB_
  STK_CHK_NP(6,1,);
  UPD_BH_UPDATABLE(R1.p);
  PUSH_UPD_FRAME(R1.p,0);
  Sp[-4]=(W_)(R1.p[4]);
  Sp[-5]=(W_)(R1.p[3]);
  Sp[-6]=(W_)(R1.p[2]);
  R1.p=(P_)(R1.p[1]);
  Sp=Sp-6;
  JMP_(ENTRY_CODE(*R1.p));
  FE_
}

INFO_TABLE_SRT(__ap_5_upd_info,__ap_5_upd_entry,5,0,0,0,0,THUNK, const,IF_,0,0);
FN_(__ap_5_upd_entry) {
  FB_
  STK_CHK_NP(7,1,);
  UPD_BH_UPDATABLE(R1.p);
  PUSH_UPD_FRAME(R1.p,0);
  Sp[-4]=(W_)(R1.p[5]);
  Sp[-5]=(W_)(R1.p[4]);
  Sp[-6]=(W_)(R1.p[3]);
  Sp[-7]=(W_)(R1.p[2]);
  R1.p=(P_)(R1.p[1]);
  Sp=Sp-7;
  JMP_(ENTRY_CODE(*R1.p));
  FE_
}

INFO_TABLE_SRT(__ap_6_upd_info,__ap_6_upd_entry,6,0,0,0,0,THUNK, const,IF_,0,0);
FN_(__ap_6_upd_entry) {
  FB_
  STK_CHK_NP(8,1,);
  UPD_BH_UPDATABLE(R1.p);
  PUSH_UPD_FRAME(R1.p,0);
  Sp[-4]=(W_)(R1.p[6]);
  Sp[-5]=(W_)(R1.p[5]);
  Sp[-6]=(W_)(R1.p[4]);
  Sp[-7]=(W_)(R1.p[3]);
  Sp[-8]=(W_)(R1.p[2]);
  R1.p=(P_)(R1.p[1]);
  Sp=Sp-8;
  JMP_(ENTRY_CODE(*R1.p));
  FE_
}

INFO_TABLE_SRT(__ap_7_upd_info,__ap_7_upd_entry,7,0,0,0,0,THUNK, const,IF_,0,0);
FN_(__ap_7_upd_entry) {
  FB_
  STK_CHK_NP(9,1,);
  UPD_BH_UPDATABLE(R1.p);
  PUSH_UPD_FRAME(R1.p,0);
  Sp[-4]=(W_)(R1.p[7]);
  Sp[-5]=(W_)(R1.p[6]);
  Sp[-6]=(W_)(R1.p[5]);
  Sp[-7]=(W_)(R1.p[4]);
  Sp[-8]=(W_)(R1.p[3]);
  Sp[-9]=(W_)(R1.p[2]);
  R1.p=(P_)(R1.p[1]);
  Sp=Sp-9;
  JMP_(ENTRY_CODE(*R1.p));
  FE_
}

INFO_TABLE_SRT(__ap_8_upd_info,__ap_8_upd_entry,8,0,0,0,0,THUNK, const,IF_,0,0);
FN_(__ap_8_upd_entry) {
  FB_
  STK_CHK_NP(10,1,);
  UPD_BH_UPDATABLE(R1.p);
  PUSH_UPD_FRAME(R1.p,0);
  Sp[-4]=(W_)(R1.p[8]);
  Sp[-5]=(W_)(R1.p[7]);
  Sp[-6]=(W_)(R1.p[6]);
  Sp[-7]=(W_)(R1.p[5]);
  Sp[-8]=(W_)(R1.p[4]);
  Sp[-9]=(W_)(R1.p[3]);
  Sp[-10]=(W_)(R1.p[2]);
  R1.p=(P_)(R1.p[1]);
  Sp=Sp-10;
  JMP_(ENTRY_CODE(*R1.p));
  FE_
}
