-- Standard list functions

#ifdef HEAD
module PreludePackString 
	( primUnpackString    -- unpack Hugs-generated string constants
	, primPackString      -- pack String into ByteArray
	, primUnpackCString   -- unpack null-terminated string
	, unsafeUnpackCString -- unpack null-terminated string
	)
  where

import qualified Char(isSpace)
import PreludeBuiltin
#endif /* HEAD */
#ifdef BODY

-- Unpack strings generated by the Hugs code generator.
-- Strings can contain \0 provided they're coded right.
-- 
-- ToDo: change this (and Hugs code generator) to use ByteArrays
primUnpackString :: Addr -> String
primUnpackString a = unpack 0
 where
  -- The following decoding is based on evalString in the old machine.c
  unpack i
    | c == '\0' = []
    | c == '\\' = if '\\' == primIndexCharOffAddr a (i+1)
                  then '\\' : unpack (i+2)
                  else '\0' : unpack (i+2)
    | otherwise = c : unpack (i+1)
   where
    c = primIndexCharOffAddr a i

primPackString :: [Char] -> PrimByteArray
primPackString str = runST (do
  { let len = length str
  ; arr <- primNewByteArray (len+1)
  ; sequence (zipWith (primWriteCharArray arr) [0..] str)
  ; primWriteCharArray arr len '\0'
  ; primUnsafeFreezeByteArray arr
  })

-- Note that this version is in the IO monad and copies the whole string
-- immediately!
primUnpackCString :: Addr -> IO String
primUnpackCString a = unpack 0 []
 where
  unpack i acc = do 
    { c <- primReadCharOffAddr a i
    ; if c == '\0'
	   then return (reverse acc)
	   else unpack (i+1) (c:acc)
    }

primUnpackCStringAcc :: Addr -> Int -> String -> IO String
primUnpackCStringAcc a n acc = unpack n acc
 where
  unpack 0 acc
    = return acc
  unpack (n+1) acc
    = do 
      { c <- primReadCharOffAddr a n
      ; unpack n (c:acc)
      }
      
unsafeUnpackCString :: Addr -> String
unsafeUnpackCString = unsafePerformIO . primUnpackCString

#endif /* BODY */
