% -----------------------------------------------------------------------------
% $Id: Foreign.lhs,v 1.8 2000/04/17 12:49:32 panne Exp $
%
% (c) The FFI task force, 2000
%

A collection of data types, classes, and functions for interfacing
with another programming language. This is only a convenience module
in the future, but currently it has the additional task of hiding
those entities exported from other modules, which are not part of the
FFI proposal.

\begin{code}
module Foreign
        ( module Int
	, module Word
	, module Addr
	, module ForeignObj
	, module StablePtr
        , module Storable
        ) where
\end{code}

\begin{code}
import Int        	( Int8,  Int16,  Int32,  Int64 )
import Word		( Word8, Word16, Word32, Word64 )
import Addr		( Addr, AddrOff, nullAddr, alignAddr, plusAddr, minusAddr )
import ForeignObj
#ifndef __PARALLEL_HASKELL__
			( ForeignObj, makeForeignObj, addForeignFinalizer, foreignObjToAddr )
#endif
import StablePtr
import Storable
\end{code}
