\documentstyle{report}
\begin{document}
\section[Abstract_syntax]{Abstract syntax definition}

>module AbsSyntax where

>import Names
>import TypeReps

>data Program	= Module	ModName Binds
>		deriving Text

>type Guard = Expr


>data Binds = NonRec MonoBinds			-- Set of bindings
>		| Rec MonoBinds				-- Recursive bindings
>               | TypeLambda [MonoType] Binds
>		| ThenBinds Binds Binds	-- nested decls
>		deriving Text


>data MonoBinds =  AndMonoBinds MonoBinds MonoBinds	-- A set of bindings
>		| PatMonoBind Pat GRHSs			-- A pattern binding
>		| VarMonoBind FunName Matches		-- A function binding
>		| SigMonoBind SigName TypeSig		-- A type signature
>-- the report says there is a list of var names instead of one here
>		deriving Text

\section[TcMonoBinds]{TcMonoBinds}

>module TcMonoBinds (tcRecMonoBinds,tcNonRecMonoBinds) where

>import AbsSyntax
>import Sap
>import Subst		
>import NameSupply	
>import E
>import CVE		
>import LVE
>import TcPat
>import TcGRHSs
>import AuxFuns
>import TypeReps	
>import TcMatch

>tcRecMonoBinds :: E -> MonoBinds -> Sap (MonoBinds,LVE)

>tcRecMonoBinds e (AndMonoBinds monobind1 monobind2)
> =		(tcRecMonoBinds e monobind1)
>   `thenS`	(\ (monobind1',lve1) -> (tcRecMonoBinds e monobind2)
>   `thenS`	(\ (monobind2',lve2) 
>                 -> returnS (AndMonoBinds monobind1' monobind2',
>                             plusLVE lve1 lve2)))


>tcRecMonoBinds e (PatMonoBind pat grhss)
> = 		(tcPat (cveOfE e) pat)
>   `thenS`	(\ (pat',patMonotype,lve) -> (tcGRHSs (growE_LVE e lve) grhss)
>   `thenS`	(\ (grhss',grhssMonotype) -> (substitute patMonotype)
>   `thenS`     (\ patMonotype' -> (unifyMonoType patMonotype' grhssMonotype)
>   `thenS`	(\ _ -> (substitutePat pat')
>   `thenS`	(\ pat'' -> (substituteLVE lve)
>   `thenS`	(\ lve' -> returnS (PatMonoBind pat'' grhss', lve')))))))


>tcRecMonoBinds e (VarMonoBind name matches)
> = 	 	(tcMatch e matches)
>   `thenS`	(\ (matches',match_monotype) -> (substituteMatches matches')
>   `thenS`	(\ matches''
>                  -> returnS (VarMonoBind name matches'',
>                              unitLVE name match_monotype)))


>tcNonRecMonoBinds :: E -> MonoBinds -> Sap (MonoBinds,LVE)
>tcNonRecMonoBinds e (AndMonoBinds monobind1 monobind2)
> =		(tcNonRecMonoBinds e monobind1)
>   `thenS`	(\ (monobind1',lve1) -> (tcNonRecMonoBinds e monobind2)
>   `thenS`	(\ (monobind2',lve2) 
>                 -> returnS (AndMonoBinds monobind1' monobind2',
>                             plusLVE lve1 lve2)))


>tcNonRecMonoBinds e (PatMonoBind pat grhss)
> = 		(tcPat (cveOfE e) pat)
>   `thenS`	(\ (pat',patMonotype,lve) -> (tcGRHSs e grhss)
>   `thenS`	(\ (grhss',grhssMonotype) -> 
>                          (unifyMonoType patMonotype grhssMonotype)
>   `thenS`	(\ _ -> (substitutePat pat')
>   `thenS`	(\ pat'' -> (substituteLVE lve)
>   `thenS`	(\ lve' -> returnS (PatMonoBind pat'' grhss', lve'))))))


>tcNonRecMonoBinds e (VarMonoBind name matches)
> = 	 	(tcMatch e matches)
>   `thenS`	(\ (matches',match_monotype) -> (substituteMatches matches')
>   `thenS`	(\ matches''
>                  -> returnS (VarMonoBind name matches'',
>                              unitLVE name match_monotype)))

\printindex
\end{document}
