\begin{onlystandalone}
\documentstyle[literate]{report}
\rootsectiontype{\part}
\begin{document}
\author{Hugo Z.~Hackenbush}
\date{8~February, 1990}
\title{The properties\\
of various nights\\
and the correlations between them
}
\maketitle
\tableofcontents
\clearpage
\listoffigures
\listoftables
\cleardoublepage
\end{onlystandalone}

\menuentry{Light_clear_day}{Superquick way to get there}

\define{\BigElephants}{Phil and Simon}

\section[Dark_stormy_night]{It was a dark and stormy night}
\owner{Hugo~Hackenbush}

\subsection{The dark night}

\section3*[darkness]{Darkness}

\centerline{Darkness often happens in the middle}
\begin{comment}
OK, just how silly does the \pl{\centerline} thing look?
\end{comment}

\section3*[nights]{Nighttime}

\begin{description}
\item[@long nights@:]
Quite common.
\item[@short nights@:]
Equally common.
\item[@cold nights@:]
All too often.
\item[@freezing nights@:]
Hey, this happens too, I'm afraid.  There are two flavors:
\begin{itemize}
\item
Generally-unpleasant.  The common flavor.
\item
Death-inducing.  Need I say more?
\begin{enumerate}
\item
Whether I need to or not, I am saying it.
\item
Not that I have {\em that} much to say.  Perhaps I will draw an arrow
or two: $\longrightarrow$, $\Longleftrightarrow$.
\begin{quotation}
I should put a quote in here about the slings and arrows of outrageous
hacking.
\end{quotation}
\end{enumerate}
\end{itemize}
\end{description}

\subsection{The stormy night}

\begin{code}
main _ = [AppendChan g_indexable' "It was a dark and stormy night\n"]
--idx::boring main function
\end{code}
The \BigElephants{} show will determine the quality of this code in the
end.

\appendix

\section[Light_clear_day]{It was a light and clear day}

Here we compare a different kind of part of the day:

\begin{tabular}{lrl}
PERIOD & FLAVOR & COMMENT \\ \hline
day    & dark   & Common in many places\\
       & stormy & Common in Timbuktu\\
night  & light  & Rare except for the Arctic\\
       & clear  & Rare in Glasgow\\
\end{tabular}

\subsection[light_day]{The light day}

% remember that figures don't really work in Texinfo.
\begin{figure}

> f x y z = g_indexable' x y
>
> g_indexable' :: (a -> b) -> a -> b
> g_indexable' x y = x y

\caption{A truly worthless bit of code}
\label{fig-label}
\end{figure}

This function @f@ doesn't refer to @groovy_wild_function@ or
@ungroovy_tame_function@\noindex{}; the latter should not be indexed.

This is a \sectiontype{light_day} or \Sectiontype{light_day}.

\subsection[clear_day]{The clear day}
\label{clear_day_really}

Before reading this you should consult \sectionref{darkness} or
\Sectionref{nights}.\index{clear_day_really@\clear_day_really}

\heading{Just a heading}

\begin{display}
The right thing to put here\footnote{I wonder why regular \LaTeX{} doesn't have something like the \tr{display} environment.}
is a poem
\end{display}
\index{poetry}%

\heading{Just another heading}

\begin{flushverbatim}
This looks like a poem but
it isn't.
\end{flushverbatim}

\begin{pseudocode}
main _ = [AppendChan stdout "It was neither dark not stormy\n"]
\end{pseudocode}
% try to reference a \label...
This is a lie not unlike that in section~\ref{clear_day_really}.

\begin{onlystandalone}
\printindex
\end{document}
\end{onlystandalone}
