\section[CoreSyntax]{The middle-end data type for the \Haskell{} compiler}

[Original version by Simon, 11~July~1990; since mangled by Will, with
a supporting cast of GRASPing thousands.]

\begin{code}
module CoreSyntax (
    CoreProgram,
    CoreBinding,
    CoreExpr(..),
    CoreCaseAlternative(..),
    CoreLiteral(..),
    CorePrimitiveOp(..),
    
    ConTag, -- type
    unknownConTag, firstConTag, defaultConTag, -- magic values of...
    tagOf   -- maps constructors to tags
) where

import Names -- for TyVarName; should be changed?
import BindingInfo	-- what info is kept for binders and bindees
import AbsSyntaxTypes
\end{code}

[Simon questions:]
\begin{itemize}
\item
Question: which types are monotypes and which polytypes?
\item
Question: is the deal with @CoCon@ OK?
\item
Question: should we attach a type to every Local?
\end{itemize}

Will questions:
\begin{itemize}
\item
Line numbers, other annotations ?

\item
I assume import / export lists (and that sort of thing) are kept
elsewhere.
\end{itemize}

%% @Name@-related things come from the appropriate modules.  @LocalVar@s
%% and @LocalTyVar@s are common name-ish things that occur herein.
%% @LocalVar@ is a locally-bound variable; represented by a name,
%% de~Bruijn number, etc.~(see in @Names@).  @LocalTyVar@ is a type
%% variable.
%% \begin{code}
%% -- simon's suggestions:
%% --type LocalVarName   = Name
%% --type LocalTyVarName = Name
%% -- I'm just using VarName and TyVarName; is that OK?
%% -- Is the "Local" necessary?
%% \end{code}

\subsection[CoreProgram_and_CoreBinding]{@CoreProgram@ and @CoreBinding@}

At this stage, a program is just a list of (recursive) bindings of
variables to @CoreExpr@s (and their types).  @BinderInfo@ and
@BindeeInfo@ records hold the extra information that
may be kept about binding and bound occurrences of variables,
respectively.
\begin{code}
type CoreProgram = [CoreBinding]
type CoreBinding = (BinderInfo, TauType, CoreExpr)
\end{code}
