#
# Generated automatically from config.mk.in by configure.
#
################################################################################
#
#			config.mk.in-template
#
#	This file defines all the variables that set the configuration of
#	a particular build.
#
#
################################################################################

# The configuration is defined in two steps:
#
#	1. The builder (i.e. the person doing the build)
#	   copies this file, config.mk.in-template
#	   to config.mk.in
#
#	2. S/he then edits it manually (gasp) to reflect any configuration
#	   options s/he wants.
#
#	3. Then s/he runs "configure", which generates config.mk from
#	   config.mk.in, substituting for system/platform-dependent things
#	   enclosed in @at-signs@.
#
# This is one of only two files that configure generates (the other is config.h)
#
# Note that after subsequent edits of config.mk.in for a build, the configure script
# will have to be re-run manually to have the change reflected in config.mk. 
#

# There is a section below for each project within the fptools suite
#
#	PLUS
#
# a section corresponding to each of the main .mk files 
# included by boilerplate.mk (see boilerplate.mk for a list).


################################################################################
#
#		Project-wide platform variables
#
################################################################################

# A "platform" is the GNU cpu-type/manufacturer/operating-system target machine
# specifier.  E.g. sparc-sun-solaris2

HOSTPLATFORM			= i386-unknown-linux
TARGETPLATFORM			= i386-unknown-linux
BUILDPLATFORM			= i386-unknown-linux

# Hack alert:
# in one or two places, we need to get at the OS version (major and perhaps even minor),
# HostOS_Full is the OS name reported by AC_CANONICAL_SYSTEM.
#
HostPlatform_CPP		= i386_unknown_linux
HostArch_CPP			= i386
HostOS_CPP			= linux
HostOS_Full			= linux
HostVendor_CPP	                = unknown

#
# ToDo: check if these can be purged now. -- sof
#

i386_unknown_linux_HOST        = 1
i386_unknown_linux_TARGET      = 1
i386_unknown_linux_BUILD       = 1

i386_HOST_ARCH       = 1
i386_TARGET_ARCH	= 1
i386_BUILD_ARCH      = 1

linux_HOST_OS           = 1
linux_TARGET_OS         = 1
linux_BUILD_OS          = 1

unknown_HOST_VENDOR    = 1
unknown_TARGET_VENDOR  = 1
unknown_BUILD_VENDOR   = 1

# Leading underscores on symbol names in object files
# Valid options: YES/NO
#
LeadingUnderscore=NO

# Pin a suffix on executables? If so, what. (cygwin32 only).
exeext=

################################################################################
#
#		project-wide flags
#
# 	Set of options applicable to all fptools projects
#
################################################################################

#
# What parts to build: An fptools build tree does not have to be built
# all in one go. By setting the list of ProjectsToBuild in build.mk you can
# control which projects are built.
#
# Caution: the projects are built in the order given here, so if some
# projects use others you must list them in the correct order.
#
# Generally: 	* glafp-utils should be first
#		* happy next
#		* ghc next
#		then it's up to you

ProjectsToBuild   = glafp-utils ghc hslibs
#
# Make a distinction between building and installing
#
ProjectsToInstall = glafp-utils ghc hslibs

#
# Should the various project tests directories be built?
#
IncludeTestDirsInBuild=NO

################################################################################
#
#		GHC project
# 
# 	Set of (configurable) options needed by the ghc tree
#	plus their default options (if any).
#
################################################################################

#---------------------------------------------------------------
#
# Variables that control how the compiler itself is built
#
#---------------------------------------------------------------

# Specify the Haskell compiler to be used to compile the compiler itself
#
#   WithGhcHc	   Path name of the compiler to use
#
#   WithGhcHcType  What "type" of compiler is being used
#		   Valid options:
#		       	     HC_CHALMERS_HBC
#		       	     HC_GLASGOW_GHC
#		       	     HC_ROJEMO_NHC
#		       	     HC_UNSPECIFIED

WithGhcHc = /net/azdak/dsg/local/i386-unknown-linux/bin/ghc

# Variable which is set to the version number of the $(WithGhcHc) we're using.
# Not currently used, but might come in handy sometime soon.
#WithGhcHcVersion = $(shell echo `if ( $(WithGhcHc) --version 2>/dev/null >/dev/null ) then $(WithGhcHc) --version 2>&1 | /bin/sed -e 's/^.*version [^0-9]*\([.0-9]*\).*/\1/;s/\.//'; else echo unknown; fi; ` )

# Extra ways in which to build the compiler (for example, you might want to
# build a profiled compiler so you can see where it spends its time)
GhcCompilerWays=

# Extra option flags to pass to the compiler that compiles the compiler
# (Ones that are essential are wired into ghc/compiler/Makefile)
# Typical ones:
#	-H25m		allocate a bigger heap (might speed up compilation)
#
#	-O		compile an optimised compiler
#
#	-DDEBUG		include consistency/assertion checks in the compiled compiler
#
#	-dcore-lint	check the types after every pass of the compiler;
#			a pretty strong internal check
GhcHcOpts=

# GhcWithHscBuiltViaC - build GHC compiler proper (\`hsc') from .hc files?
GhcWithHscBuiltViaC=NO

# Build a registerised version of hsc and runtime
# (unregisterised used for Hugs at the moment)
GhcWithRegisterised=YES

# Build a compiler with a native code generator backend
# (as well as a C backend)
#
# Target platforms supported:
#   i386, alpha & sparc
GhcWithNativeCodeGen=$(shell if (test x$(findstring $(HostArch_CPP),i386 alpha sparc) = x); then echo NO; else echo YES; fi)

#
# Building various ways?
# (right now, empty if not).
BuildingParallel=$(subst mp,YES,$(filter mp,$(WAYS)))
BuildingGranSim=$(subst mg,YES,$(filter mg,$(WAYS)))

# Include compiler support for letting the compiler (optionally) report
# your compilation to a central server for generation of fun stats.
#
GhcReportCompiles=NO

#------------------------------------------------------------------------------
# Options for GHC's Prelude

# What extra ways to build the libraries in
# In addition to the normal sequential way, the default is to also build
# profiled prelude libraries.
# When booting from .hc files, turn this off.
ifeq "$(GhcWithHscBuiltViaC)" "YES"
GhcLibWays=
else
GhcLibWays=p
endif

# Option flags to pass to GHC when it's compiling prelude modules
# Typically these are things like -O or -dcore-lint
# The ones that are *essential* are wired into ghc/lib/Makefile
#
# 	-O is pretty desirable, otherwise no inlining of prelude
#		things (incl "+") happens when compiling with this compiler

GhcLibHcOpts=-O

# Win32 only: Enable the RTS and libraries to be built as DLLs
# Don't split object files for libs if we're building DLLs
EnableWin32DLLs=NO
ifeq "($EnableWin32DLLs)" "YES"
SplitObjs=NO
else
SplitObjs=YES
endif


# Strip local symbols from libraries?  This can make the libraries smaller,
# but makes debugging somewhat more difficult.  Doesn't work with all ld's.
#
StripLibraries=NO

# ----------------------------------------------------------------------------
# Options for GHC's RTS

# This is a good way to set things like -optc-g and -optc-DDEBUG for the RTS.
# GhcRtsHcOpts is used when compiling .hc files and .c files.
# GhcRtsCcOpts is used when compiling .c  files only.

# For a debugging RTS:
# GhcRtsHcOpts = -optc-DDEBUG
# GhcRtsCcOpts = -optc-g

# For an optimised RTS:
GhcRtsHcOpts=-O2
GhcRtsCcOpts=-O2 -optc-fomit-frame-pointer

################################################################################
#
#		hslibs project
#
################################################################################

# Build HsLibs for which compiler?  

# If $(HsLibsFor) == hugs or ghc, we assume we're building for the
# compiler/interpreter in the same source tree.

# HsLibsFor = ghc | hugs | nhc | hbc
HsLibsFor	= ghc

# hslibs for GHC also uses the following variables (defined above):
#   GhcLibWays, GhcLibHcOpts, EnableWin32DLLs, StripLibraries

# Build the Haskell Readline bindings?
#
GhcLibsWithReadline=NO
#
# Include path to readline.h
# (no path == in standard include path)
#
ReadlineIncludePath=
HaveLibReadline=YES

################################################################################
#
#		happy project
#
# 	Happy specific options
#
################################################################################

# The compiler you'd like to use to compile Happy
WithHappyHc = /net/azdak/dsg/local/i386-unknown-linux/bin/ghc

# HappyHcOpts gives the flags to pass to the Haskell compiler used
# 	      to compile the Happy sources with.
#
HappyHcOpts = -O

################################################################################
#
#		haggis project
#
# 	Haggis specific options
#
################################################################################

################################################################################
#
#		green-card project
#
# 	Green-card specific options
#
################################################################################

################################################################################
#
#		nofib project
#
# 	nofib specific options
#
################################################################################

WithNofibHc = $(GHC_INPLACE)

# NoFibSubDirs controls which set of tests should be run
# You can run one or more of
#	imaginary 
#	spectral
#	real
#	parallel
#	PRIVATE
#	PENDING
#	UNUSED
NoFibSubDirs = imaginary spectral real

# The different ways to build nofib. Default is just to mirror
# what is done for the ghc prelude libraries.
#
NoFibWays = $(GhcLibWays)

# Haskell compiler options for nofib
NoFibHcOpts = -O

# ==============================================================================
#
#			END OF PROJECT-SPECIFIC STUFF
#
#		Now come the generic configuration options
#
# ==============================================================================

################################################################################
#
#		Paths (see paths.mk)
#
################################################################################

# Directory used by GHC (and possibly other tools) for storing
# temporary files.  If your /tmp isn't big enough, either override
# this in build.mk or set your environment variable "TMPDIR" to point
# to somewhere with more space.  (TMPDIR=. is a good choice).

TMPDIR			= /tmp

# FPTOOLS_TOP: the top of the fptools hierarchy, absolute path.

FPTOOLS_TOP_ABS		= /usr/local2/BUILDS/gdh/i386-unknown-linux

#
# Installation directories, we don't use half of these,
# but since the configure script has them on offer while
# passing through, we might as well set them.

prefix                  = /usr/local
exec_prefix             = ${prefix}
bindir                  = ${exec_prefix}/bin
#UNUSED, see below: libexecdir              = ${exec_prefix}/libexec
datadir                 = ${prefix}/share
#sysconfdir              = ${prefix}/share
#sharedstatedir          = ${prefix}/com
#localstatedir           = ${prefix}/var
libdir                  = ${exec_prefix}/lib
infodir		        = ${prefix}/info
includedir              = ${prefix}/include
oldincludedir           = /usr/include
mandir			= ${prefix}/man
#UNUSED:srcdir          = .

# 
# Default values for most of the above are only set if
# they weren't configured to anything in particular
# via the configure script. (i.e., we make no assumption
# that the autoconf-generated script will assign defaults
# to all of the above).
#
ifeq "$(strip $(exec_prefix))" ""
exec_prefix		= $(prefix)
endif
ifeq "$(strip $(bindir))" ""
bindir			= $(exec_prefix)/bin
endif

#
# NOTE: by intention, libexecdir and libdir point to 
# the same place.
#  => Only way to override this is to set libexecdir= on the command line.
#     (NOTE: configure script setting is ignored).
libexecdir		= $(libdir)

ifeq "$(strip $(datadir))" ""
datadir		= $(prefix)/share
endif
ifeq "$(strip $(libdir))" ""
libdir		= $(exec_prefix)/lib
endif
ifeq "$(strip $(infodir))" ""
infodir		= $(prefix)/info
endif
ifeq "$(strip $(includedir))" ""
includedir	= $(prefix)/include
endif
ifeq "$(strip $(oldincludedir))" ""
oldincludedir	= /usr/include
endif
ifeq "$(strip $(mandir))" ""
mandir		= $(prefix)/man
endif
 

################################################################################
#
#		Utilities programs: flags
#
################################################################################

# If you want to give any standard flags to pretty much any utility
# (see utils.mk for a complete list), by adding a line here
#
# 	SRC_P_OPTS += ...
#
# where P is the utility. For example, to add -O to all Haskell
# compilations, 
#
#	SRC_HC_OPTS += -O


################################################################################
#
#		Utilities programs: where to find them
#
################################################################################

#-----------------------------------------------------------------------------
# FPtools Utility locations

# By default, the various utils needed to be build ghc and chums
# is set up to point to the utils/ directory. Define here the
# path prefix for the utilities. Notice that it's a prefix with
# a trailing slash, so that it can be concatenated directly on
# front of a program name; if it's not set then we just look
# along the shell's $(PATH)
#
# If instead you want to use installed or your own versions of these,
# override the various *_PREFIX in build.mk, i.e., having the following
# in build.mk:
#
#   MKDEPENDC_PREFIX=
#
# will force `make' to rummage around in your PATH to find `mkdependC' (not
# sure it would need it in the first place, but still).
#
GLAFP_UTILS  		= $(FPTOOLS_TOP)/glafp-utils

SCRIPT_PREFIX 		= $(GLAFP_UTILS)/scripts/
MKDEPENDC_PREFIX	= $(GLAFP_UTILS)/mkdependC/
LTX_PREFIX		= $(GLAFP_UTILS)/ltx/
RUNTEST_PREFIX		= $(GLAFP_UTILS)/runstdtest/
VERBATIM_PREFIX		= $(GLAFP_UTILS)/verbatim/
SGMLVERB_PREFIX		= $(GLAFP_UTILS)/sgmlverb/
ETAGS_PREFIX		= $(GLAFP_UTILS)/etags/
MSUB_PREFIX		= $(GLAFP_UTILS)/msub/
LNDIR_PREFIX		= $(GLAFP_UTILS)/lndir/
MKDIRHIER_PREFIX	= $(GLAFP_UTILS)/mkdirhier/

# Still used?
LITERATE	    	= $(FPTOOLS_TOP)/literate

LITERATE_PREFIX    	= $(FPTOOLS_TOP)/literate/
INFO_PREFIX    	        = $(FPTOOLS_TOP)/literate/info-utils/
TEXI2HTML_PREFIX        = $(LITERATE_PREFIX)texi2html/

HAPPY_PREFIX    	= $(FPTOOLS_TOP)/happy/src/
GREENCARD_PREFIX	= $(FPTOOLS_TOP)/green-card/src/

UNLIT_PREFIX    	= $(FPTOOLS_TOP)/ghc/utils/unlit/
UGEN_PREFIX             = $(FPTOOLS_TOP)/ghc/utils/ugen/
STAT2RESID_PREFIX       = $(FPTOOLS_TOP)/ghc/utils/stat2resid/
HP2PS_PREFIX            = $(FPTOOLS_TOP)/ghc/utils/hp2ps/
HSCPP_PREFIX            = $(FPTOOLS_TOP)/ghc/utils/hscpp/
HSTAGS_PREFIX           = $(FPTOOLS_TOP)/ghc/utils/hstags/


#-----------------------------------------------------------------------------
# Haskell compilers and mkdependHS

# $(GHC), $(HBC) and $(NHC) point to installed versions of the relevant
# compilers, if available.
#
# $(HC) is a generic Haskell 98 compiler, set to $(GHC) by default.
# $(MKDEPENDHS) is the Haskell dependency generator (ghc -M).

GHC		= /net/azdak/dsg/local/i386-unknown-linux/bin/ghc
HBC		= 
NHC		= /net/azdak/dsg/local/i386-unknown-linux/bin/nhc98

HC	        = /net/azdak/dsg/local/i386-unknown-linux/bin/ghc
MKDEPENDHS	= $(HC)

# Sometimes we want to invoke ghc from the build tree in different
# projects (eg. it's handy to have a nofib & a ghc build in the same
# tree).  We can refer to "this ghc" as $(GHC_INPLACE):

GHC_INPLACE 	= $(FPTOOLS_TOP)/ghc/driver/ghc-inplace

#-----------------------------------------------------------------------------
# C compiler
#
#
HaveGcc 	= YES
UseGcc  	= YES
WhatGccIsCalled = gcc
ifeq "$(strip $(HaveGcc))" "YES"
ifneq "$(strip $(UseGcc))"  "YES"
  CC	= cc
else
  CC	= $(WhatGccIsCalled)
endif
endif

#-----------------------------------------------------------------------------
# GMP Library (version 2.0.x or above)
#
HaveLibGmp	= YES
LibGmp		= gmp

#-----------------------------------------------------------------------------
# Flex

FLEX			= flex
# Don't bother with -lfl, we define our own yywrap()s anyway.
FLEX_LIB		= 
#WAS:FLEX_LIB		= -lfl

#-----------------------------------------------------------------------------
# Other standard (ha!) Unix utilities

AR			= /usr/bin/ar clqs
# Yuckage: for ghc/utils/parallel -- todo: nuke this dependency!!
BASH                    = /usr/local/bin/bash
#
# Could be either gzip or compress
#
COMPRESS		= /bin/gzip -d
COMPRESS_SUFFIX         = gz

CONTEXT_DIFF		= diff -C 1
CP			= cp
CPP			= gcc -E
CTAGS 			= $(ETAGS)
RAWCPP                  = $(CPP) -undef -traditional
FIND			= /usr/bin/find
INSTALL			= /usr/bin/install -c
#
# Sigh - the autoconf macro for INSTALL will subst a relative path to the fallback
# install-sh script (if chosen). This not terribly useful to us, so we convert
# it into an abs. path.
# 
INSTALL			:= $(subst .././install-sh,$(FPTOOLS_TOP_ABS)/install-sh,$(INSTALL))
LATEX			= latex
LN_S			= ln -s
MANMACROS		= -man
MSMACROS 		= -ms
MV			= mv
NROFF			= nroff
PERL 			= /usr/bin/perl
BASH			= @BashCmd@
PIC			= pic
PREPROCESSCMD		= $(CC) -E
PRINTER			= lpr
RANLIB			= :
RM			= rm -f
SED			= /bin/sed
SHELL			= /bin/sh
#
# In emergency situations, REAL_SHELL is used to perform shell commands
# from within the ghc driver script, by scribbling the command line to
# a temp file and then having $(REAL_SHELL) execute it. 
#
# The reason for having to do this is that overly long command lines
# cause unnecessary trouble with some shells (e.g., /bin/sh on Solaris
# 2.5.1), which is why this backdoor is provided. The situation of overly
# long command lines is either encountered while doing `make boot' in ghc/compiler, 
# or when linking the compiler binary (`hsc'). 
#
# We do not use SHELL to execute long commands, as `make' will more than likely
# override whatever setting you have in your environment while executing. 

# By default, REAL_SHELL is set equal SHELL, which is not really a smart move
# as it is SHELL that will show up the bogosity in the first place, but setting
# it to anything else isn't really portable.
#
#  ====> If long command lines cause you trouble, invoke `ghc' (via `make' or otherwise)
# with REAL_SHELL set to something else than /bin/sh, for instance, your favourite
# command shell.
#
REAL_SHELL=$(SHELL)
SIZE			= size
STRIP			= strip
TAR			= /bin/gtar
ZIP			= zip

#
# Under cygwin32, we have to deal with .exe suffixes
#
EXE_SUFFIX=@ExeSuffix@

#
# This is special to literate/, ToDo: add literate-specific
# configure setup to literate/.
#
TBL 			= tbl
TEX			= tex
TGRIND 			= tgrind
TGRIND_HELPER 		= /usr/local/lib/tgrind/tfontedpr # XXX
TIB			= tib

TIME			= /usr/bin/time
TROFF			= troff
UNAME			= uname
YACC			= bison -y

#-----------------------------------------------------------------------------
# SGML stuff (currently not configured - we assume you have it)

SGML2DVI		= db2dvi
SGML2HTML		= db2html
SGML2INFO		= db2info
SGML2RTF		= db2rtf

SGMLSTYLESHEET          = $(FPTOOLS_TOP_ABS)/docs/fptools-both.dsl

SRC_SGML2DVI_OPTS       = -d $(SGMLSTYLESHEET)
SRC_SGML2HTML_OPTS      = -d $(SGMLSTYLESHEET)
SRC_SGML2INFO_OPTS      = -d $(SGMLSTYLESHEET)
SRC_SGML2RTF_OPTS       = -d $(SGMLSTYLESHEET)

#-----------------------------------------------------------------------------
# 		FPtools support software

# Stuff from fptools/glafp-utils
MKDEPENDC 		= $(MKDEPENDC_PREFIX)mkdependC
LTX 			= $(LTX_PREFIX)ltx
MKDIRHIER		= $(MKDIRHIER_PREFIX)mkdirhier
LNDIR			= $(LNDIR_PREFIX)lndir
MSUB			= $(MSUB_PREFIX)msub
ETAGS			= $(ETAGS_PREFIX)etags
VERBATIM		= $(VERBATIM_PREFIX)verbatim
SGMLVERB		= $(SGMLVERB_PREFIX)sgmlverb
RUNTEST			= $(RUNTEST_PREFIX)runstdtest
HAPPY			= /net/azdak/dsg/local/i386-unknown-linux/bin/happy
HAPPY_VERSION		= 1.6		
LX			= @LxCmd@
GREENCARD	        = $(FPTOOLS_TOP)/green-card/src/green-card

BLD_DLL			= dllwrap

#
# Stuff from fptools/literate
#
INFO         		= $(UTIL_PREFIX)info
MAKEINFO     		= $(INFO_PREFIX)makeinfo
POSTMAKEINFO 		= $(INFO_PREFIX)postmakeinfo
LIT2PGM 		= $(LITERATE_PREFIX)lit2pgm
LIT2TEXI      		= $(LITERATE_PREFIX)lit2texi
LIT2HTML      		= $(LITERATE_PREFIX)lit2html
LIT2LATEX     		= $(LITERATE_PREFIX)lit2latex
MKDEPENDLIT   		= $(LITERATE_PREFIX)mkdependlit
LIT2CHANGELOG 		= $(LITERATE_PREFIX)lit2changelog
LIT2TEXT 		= $(LITERATE_PREFIX)lit2text
TEXI2HTML               = $(TEXI2HTML_PREFIX)texi2html

#
# Stuff from fptools/ghc/utils
#
UNLIT	 		= $(UNLIT_PREFIX)unlit
UGEN			= $(UGEN_PREFIX)ugen
STAT2RESID		= $(STAT2RESID_PREFIX)stat2resid
HP2PS			= $(HP2PS_PREFIX)hp2ps
HSCPP			= $(HSCPP_PREFIX)hscpp
HSTAGS			= $(HSTAGS_PREFIX)hstags

#
# Options for the compiling different `ways'. Various projects within
# the glorious fptools tree support building in various user-configured
# ways. For instance, you could set up one `way' such that the prelude
# libraries all were built with the option -ffoldr-build-on.
# 
# To configure up your own way, have a look at some of the standard ways
# such as profiling, and create your own set of WAY_*_OPTS defs below.
# After having done that, add your way string to WAYS, and after having
# run the configure script, the different projects will add the new way
# to the list of ways they support.
#

#
# IMPORTANT! The WAYS variable configures the different `ways'
# you want to build a project (or maybe just parts of it, as is
# the case for ghc/). This variable is intended set inside the
# project mk setup, enforcing a global fptools WAYS is a bit too
# much (do you *really* want to build glafp-utils the profiled-concurrent 
# way?)
#

#
# Definitions of the different ways:
#   
#   * their name:
#          - tag, e.g., p
#          - description, e.g., profiling
#   * what they mean to the driver:
#          - WAY_p_HC_OPTS gives the list of command-line options
#            to the driver.
#

#
# The ways currently defined.
#
ALL_WAYS=p t u s mp mg a b c d e f g h i j k l m n o A B
USER_WAYS=a b c d e f g h i j k l m n o A B

#
# The following ways currently have treated specially, p u t mg,
# as the driver script treats these guys specially and needs to carefully be told
# about the options for these. Hence, we hide the required command line options
# for these in the ghc/driver, as this is the only place they are needed.
# 
# If you want to add to these default options, fill in the variables below:

# Way 'p':
WAY_p_NAME=profiling
WAY_p_HC_OPTS= -prof

# Way 't':
WAY_t_NAME=ticky-ticky profiling
WAY_t_HC_OPTS= -ticky

# Way `u':
WAY_u_NAME=unregisterized (using portable C only)
WAY_u_HC_OPTS=-unreg

# Way `s':
WAY_s_NAME=threads (for SMP)
WAY_s_HC_OPTS=-smp

# Way `mp': 
WAY_mp_NAME=parallel
WAY_mp_HC_OPTS=-parallel

# Way `mg': 
WAY_mg_NAME=GranSim
WAY_mg_HC_OPTS=-gransim

# Way `dll': 
WAY_dll_NAME=Win32 DLLs
WAY_dll_HC_OPTS=

#
# Add user-way configurations here:
#
WAY_A_NAME=
WAY_A_HC_OPTS=

WAY_B_NAME=
WAY_B_HC_OPTS=

WAY_a_NAME=
WAY_a_HC_OPTS=

WAY_b_NAME=
WAY_b_HC_OPTS=

WAY_c_NAME=
WAY_c_HC_OPTS=

WAY_d_NAME=Parallel Debugging
WAY_d_HC_OPTS=-fparallel -fvia-C -fglasgow-exts -cpp -syslib concurrent -hisuf d_hi -osuf d_o

WAY_e_NAME=Parallel Ticky Profiling
WAY_e_HC_OPTS=-fparallel -fvia-C -fglasgow-exts -cpp -syslib concurrent -hisuf e_hi -osuf e_o

WAY_f_NAME=
WAY_f_HC_OPTS=

WAY_g_NAME=GranSim Debugging
WAY_g_HC_OPTS=-fgransim

WAY_h_NAME=
WAY_h_HC_OPTS=

WAY_i_NAME=
WAY_i_HC_OPTS=

WAY_j_NAME=
WAY_j_HC_OPTS=

WAY_k_NAME=
WAY_k_HC_OPTS=

WAY_l_NAME=
WAY_l_HC_OPTS=

WAY_m_NAME=
WAY_m_HC_OPTS=

WAY_n_NAME=
WAY_n_HC_OPTS=

WAY_o_NAME=
WAY_o_HC_OPTS=
